/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.cnri.util.StreamTable;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.Interface;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ServerTest {
    private static final String SITE_INFO_FILE = "siteinfo.bin";
    private static final String SITE_INFO_JSON_FILE = "siteinfo.json";
    private static HandleResolver resolver = new HandleResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTest(StreamTable config, File configDir) {
        try {
            SiteInfo site;
            File siteInfoFile = new File(configDir, SITE_INFO_FILE);
            if (!siteInfoFile.exists() || !siteInfoFile.canRead()) {
                File siteInfoJsonFile = new File(configDir, SITE_INFO_JSON_FILE);
                if (!siteInfoJsonFile.exists() || !siteInfoJsonFile.canRead()) {
                    System.err.println("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                    throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                }
                byte[] siteInfoBytes = Util.getBytesFromFile(siteInfoJsonFile);
                try {
                    site = SiteInfoConverter.convertToSiteInfo(new String(siteInfoBytes, "UTF-8"));
                }
                catch (Throwable t) {
                    System.err.println("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                    throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName(), t);
                }
            }
            site = new SiteInfo();
            byte[] siteInfoBuf = new byte[(int)siteInfoFile.length()];
            try (FileInputStream in = new FileInputStream(siteInfoFile);){
                int r;
                int n = 0;
                while ((r = ((InputStream)in).read(siteInfoBuf, n, siteInfoBuf.length - n)) > 0) {
                    n += r;
                }
            }
            Encoder.decodeSiteInfoRecord(siteInfoBuf, 0, site);
            for (int j = 0; j < site.servers.length; ++j) {
                System.out.println("SERVER: " + site.servers[j].getAddressString());
                for (int k = 0; k < site.servers[j].interfaces.length; ++k) {
                    Interface serverInterface = site.servers[j].interfaces[k];
                    try {
                        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, null);
                        resolver.sendRequestToInterface(req, site.servers[j], serverInterface);
                        System.out.print(Interface.protocolName(serverInterface.protocol));
                        System.out.println(":" + serverInterface.port + "            ***PASS***");
                        continue;
                    }
                    catch (HandleException t) {
                        System.err.println("Server: " + site.servers[j].getAddressString());
                        System.err.print(Interface.protocolName(serverInterface.protocol));
                        System.err.print(":" + serverInterface.port + "            ***FAIL***");
                        System.err.println("  " + HandleException.getCodeStr(t.getCode()));
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Invalid site/server specification");
            System.err.println("Test Failed");
            System.exit(-1);
        }
    }
}

