/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.test;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStreamReader;
import net.handle.hdllib.Common;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.Interface;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ClientTest {
    private static HandleResolver resolver = new HandleResolver();
    private static final String OSNAME = System.getProperty("os.name");
    private static boolean windows = false;
    private static boolean linux = false;

    static void testGlobalSites() {
        resolver.setTcpTimeout(10000);
        SiteInfo[] GlobalSites = resolver.getConfiguration().getGlobalSites();
        for (int i = 0; i < GlobalSites.length; ++i) {
            for (int j = 0; j < GlobalSites[i].servers.length; ++j) {
                System.out.println("\nSERVER: " + GlobalSites[i].servers[j].getAddressString());
                for (int k = 0; k < GlobalSites[i].servers[j].interfaces.length; ++k) {
                    Interface serverInterface = GlobalSites[i].servers[j].interfaces[k];
                    try {
                        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, null);
                        resolver.sendRequestToInterface(req, GlobalSites[i].servers[j], serverInterface);
                        System.out.print(Interface.protocolName(serverInterface.protocol));
                        System.out.println(":" + serverInterface.port + "                   ***PASS***");
                        continue;
                    }
                    catch (HandleException t) {
                        System.err.print(Interface.protocolName(serverInterface.protocol));
                        System.err.print(":" + serverInterface.port + "                   ***FAIL***");
                        System.err.println("  " + HandleException.getCodeStr(t.getCode()));
                    }
                }
                ClientTest.ping(GlobalSites[i].servers[j].getAddressString());
            }
        }
    }

    static void testNASites(String naHandle) {
        SiteInfo[] localSites;
        try {
            GenericRequest greq = new GenericRequest(Util.encodeString(naHandle), 2, null);
            localSites = resolver.findLocalSites(greq);
        }
        catch (HandleException t) {
            System.err.println("Error resolving prefix handle");
            return;
        }
        for (int i = 0; i < localSites.length; ++i) {
            for (int j = 0; j < localSites[i].servers.length; ++j) {
                System.out.println("SERVER: " + localSites[i].servers[j].getAddressString());
                for (int k = 0; k < localSites[i].servers[j].interfaces.length; ++k) {
                    Interface serverInterface = localSites[i].servers[j].interfaces[k];
                    try {
                        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, null);
                        resolver.sendRequestToInterface(req, localSites[i].servers[j], serverInterface);
                        System.out.print(Interface.protocolName(serverInterface.protocol));
                        System.out.println(":" + serverInterface.port + "                   ***PASS***");
                        continue;
                    }
                    catch (HandleException t) {
                        System.err.print(Interface.protocolName(serverInterface.protocol));
                        System.err.print(":" + serverInterface.port + "                   ***FAIL***");
                        System.err.println("  " + HandleException.getCodeStr(t.getCode()));
                    }
                }
                ClientTest.ping(localSites[i].servers[j].getAddressString());
            }
        }
    }

    static void ping(String server) {
        block32: {
            File pingDir;
            int i;
            String osName = OSNAME.toUpperCase().trim();
            String[] windowsPaths = new String[]{"C:\\WINNT\\SYSTEM32\\", "C:\\WINNT\\", "C:\\WINDOWS\\SYSTEM\\", "C:\\WINDOWS\\", "c:\\windows\\system32\\ping.exe"};
            String[] linuxPaths = new String[]{"/bin/", "/usr/bin/", "/sbin/", "/usr/sbin/"};
            int spcIdx = osName.indexOf(32);
            if (spcIdx != -1) {
                osName = osName.substring(0, spcIdx);
            }
            if (osName.length() > 7 || osName.length() < 5) {
                linux = false;
                windows = false;
            } else if (osName.substring(0, 5).equals("LINUX")) {
                linux = true;
                windows = false;
            } else if (osName.length() == 7 && osName.substring(0, 7).equals("WINDOWS")) {
                windows = true;
                linux = false;
            } else {
                linux = false;
                windows = false;
            }
            String pingPath = null;
            if (windows) {
                for (i = 0; i < windowsPaths.length; ++i) {
                    try {
                        pingDir = new File(windowsPaths[i], "ping.exe");
                        if (!pingDir.exists()) continue;
                        pingPath = windowsPaths[i];
                    }
                    catch (Exception e) {
                        if (i != windowsPaths.length - 1) continue;
                        System.out.println("UNABLE TO LOCATE PING");
                    }
                    break;
                }
            } else {
                for (i = 0; i < linuxPaths.length; ++i) {
                    try {
                        pingDir = new File(linuxPaths[i], "ping");
                        if (!pingDir.exists()) continue;
                        pingPath = linuxPaths[i];
                    }
                    catch (Exception e) {
                        if (i != linuxPaths.length - 1) continue;
                        System.out.println("UNABLE TO LOCATE PING");
                    }
                    break;
                }
            }
            Runtime runtime = Runtime.getRuntime();
            if (pingPath != null) {
                String[] cmd;
                if (windows) {
                    cmd = new String[]{pingPath.concat("ping"), "-n", "10", server};
                    try {
                        Process p = runtime.exec(cmd);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(new DataInputStream(new BufferedInputStream(p.getInputStream()))));
                        String lineRead = null;
                        int avgIdx = -1;
                        int lossIdx = -1;
                        int lossIdx2 = -1;
                        String avg = "error";
                        String loss = "error";
                        while ((lineRead = reader.readLine()) != null) {
                            avgIdx = lineRead.indexOf("Average");
                            lossIdx = lineRead.indexOf("%");
                            lossIdx2 = lineRead.indexOf("(");
                            if (avgIdx != -1) {
                                avgIdx = lineRead.indexOf("=", avgIdx);
                                avg = lineRead.substring(avgIdx + 3);
                            }
                            if (lossIdx == -1 || lossIdx2 == -1) continue;
                            loss = lineRead.substring(lossIdx2 + 1, lossIdx);
                        }
                        if (Integer.parseInt(loss) > 60) {
                            System.out.print("PING [avg:" + avg);
                            System.out.println("/loss:" + loss + "%]          ***FAIL***");
                            break block32;
                        }
                        if (avg.equals("error") || loss.equals("error")) {
                            System.out.println("PING                ***PASS***");
                            break block32;
                        }
                        System.out.print("PING [avg:" + avg);
                        System.out.println("/loss:" + loss + "%]      ***PASS***");
                    }
                    catch (Exception e) {
                        System.err.println("Error pinging " + server + "    ");
                    }
                } else {
                    cmd = null;
                    String[] cmdL = new String[]{pingPath.concat("ping"), "-c", "10", server};
                    String[] cmdS = new String[]{pingPath.concat("ping"), "-s", server, "56", "10"};
                    cmd = linux ? cmdL : cmdS;
                    try {
                        Process p = runtime.exec(cmd);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(new DataInputStream(new BufferedInputStream(p.getInputStream()))));
                        String lineRead = null;
                        int avgIdx = -1;
                        int lossIdx = -1;
                        int lossIdx2 = -1;
                        String avg = null;
                        String loss = null;
                        while ((lineRead = reader.readLine()) != null) {
                            avgIdx = lineRead.indexOf(" = ");
                            lossIdx2 = lineRead.indexOf("received");
                            lossIdx = lineRead.indexOf("%");
                            if (avgIdx != -1) {
                                avgIdx = lineRead.indexOf("/", avgIdx);
                                avg = lineRead.substring(avgIdx + 1, lineRead.indexOf("/", avgIdx + 1));
                            }
                            if (lossIdx == -1 || lossIdx2 == -1) continue;
                            loss = lineRead.substring(lossIdx2 + 10, lossIdx);
                        }
                        if (loss != null && Integer.parseInt(loss) > 30) {
                            System.out.print("PING [avg:" + avg);
                            System.out.println("/loss:" + loss + "%]          ***FAIL***");
                            break block32;
                        }
                        if (avg == null && loss == null) {
                            System.out.println("PING                  ***N/A***");
                            break block32;
                        }
                        System.out.print("PING [avg:" + avg + "ms");
                        System.out.println("/loss:" + loss + "%]      ***PASS***");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Error pinging " + server + ":    " + e);
                    }
                }
            } else {
                System.out.println("UNABLE TO LOCATE PING");
            }
        }
    }
}

