/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.cnri.util.SimpleCommandLine;
import net.cnri.util.StreamUtil;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.Util;
import org.apache.commons.codec.binary.Base64;

public class KeyConverter {
    private static Pattern firstLinePattern = Pattern.compile("^\\s*-----BEGIN (.*) KEY-----\\s*$");
    private final byte[] bytes;
    private final boolean encrypt;
    private String outputFilename;
    private byte[] passIn;
    private byte[] passOut;

    private static BytesAndKeyType readPemFile(Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        StringBuilder base64Only = new StringBuilder();
        String keyType = null;
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (keyType == null) {
                    Matcher m = firstLinePattern.matcher(line);
                    keyType = m.matches() ? m.group(1) : "";
                }
                if (line.startsWith("-----")) continue;
                base64Only.append(line);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        byte[] bytes = Base64.decodeBase64((String)base64Only.toString());
        return new BytesAndKeyType(bytes, keyType);
    }

    public static String toX509Pem(PublicKey publicKey) {
        byte[] data;
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PUBLIC KEY-----\r\n");
        for (byte b : data = Base64.encodeBase64((byte[])publicKey.getEncoded(), (boolean)true)) {
            sb.append((char)b);
        }
        if (data[data.length - 1] != 10) {
            sb.append("\r\n");
        }
        sb.append("-----END PUBLIC KEY-----\r\n");
        return sb.toString();
    }

    public static PublicKey publicKeyFromBytes(byte[] bytes) throws Exception {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            try {
                return KeyFactory.getInstance("RSA").generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                return KeyFactory.getInstance("DSA").generatePublic(keySpec);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("Neither RSA nor DSA public key generator can parse", e);
        }
    }

    public static PublicKey fromX509Pem(String pem) throws Exception {
        BytesAndKeyType bytesAndKeyType = KeyConverter.readPemFile(new StringReader(pem));
        if (!"PUBLIC".equals(bytesAndKeyType.keyType)) {
            throw new Exception("Expected -----BEGIN PUBLIC KEY-----");
        }
        return KeyConverter.publicKeyFromBytes(bytesAndKeyType.bytes);
    }

    public static String toPkcs8UnencryptedPem(PrivateKey privateKey) {
        byte[] data;
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PRIVATE KEY-----\r\n");
        for (byte b : data = Base64.encodeBase64((byte[])privateKey.getEncoded(), (boolean)true)) {
            sb.append((char)b);
        }
        if (data[data.length - 1] != 10) {
            sb.append("\r\n");
        }
        sb.append("-----END PRIVATE KEY-----\r\n");
        return sb.toString();
    }

    public static String toPkcs8EncryptedPem(PrivateKey privateKey, String passphrase) {
        byte[] data;
        byte[] encryptedPkcs8;
        String alg = "PBEWithSHA1AndDESede";
        int count = 10000;
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toCharArray());
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(alg);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(alg);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            byte[] ciphertext = pbeCipher.doFinal(privateKey.getEncoded());
            AlgorithmParameters algparms = AlgorithmParameters.getInstance(alg);
            algparms.init(pbeParamSpec);
            EncryptedPrivateKeyInfo encinfo = new EncryptedPrivateKeyInfo(algparms, ciphertext);
            encryptedPkcs8 = encinfo.getEncoded();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN ENCRYPTED PRIVATE KEY-----\r\n");
        for (byte b : data = Base64.encodeBase64((byte[])encryptedPkcs8, (boolean)true)) {
            sb.append((char)b);
        }
        if (data[data.length - 1] != 10) {
            sb.append("\r\n");
        }
        sb.append("-----END ENCRYPTED PRIVATE KEY-----\r\n");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey privateKeyFromBytes(byte[] bytes, boolean encrypted, String passphrase) throws Exception {
        KeySpec keySpec;
        if (encrypted) {
            if (passphrase == null) {
                throw new Exception("Encrypted key, passphrase required");
            }
            try {
                keySpec = KeyConverter.keySpecFromEncryptedBytes(bytes, passphrase);
            }
            catch (Exception e) {
                throw new Exception("Unable to decrypt private key", e);
            }
        } else {
            keySpec = new PKCS8EncodedKeySpec(bytes);
        }
        try {
            try {
                return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                try {
                    return KeyFactory.getInstance("DSA").generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e2) {
                    throw new Exception("Neither RSA nor DSA private key generator can parse", e2);
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PrivateKey fromPkcs8Pem(String pem, String passphrase) throws Exception {
        BytesAndKeyType bytesAndKeyType = KeyConverter.readPemFile(new StringReader(pem));
        boolean encrypted = "ENCRYPTED PRIVATE".equals(bytesAndKeyType.keyType);
        if (!encrypted && !"PRIVATE".equals(bytesAndKeyType.keyType)) {
            throw new Exception("Expected -----BEGIN [ENCRYPTED] PRIVATE KEY-----");
        }
        return KeyConverter.privateKeyFromBytes(bytesAndKeyType.bytes, encrypted, passphrase);
    }

    private static KeySpec keySpecFromEncryptedBytes(byte[] bytes, String passphrase) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(bytes);
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toCharArray());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
        cipher.init(2, (Key)pbeKey, encryptedPrivateKeyInfo.getAlgParameters());
        PKCS8EncodedKeySpec keySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
        return keySpec;
    }

    private static void printUsageAndExit() {
        System.err.println("arguments: [-crypt] [-passin input-password] [-passout output-password] [input-filename] [-o output-filename]");
        System.err.println();
        System.err.println("This utility converts public and private keys bidirectionally between");
        System.err.println("Handle protocol format and standard PEM format: public keys in X.509");
        System.err.println("SubjectPublicKeyInfo format (with files beginning -----BEGIN PUBLIC KEY-----)");
        System.err.println("and private keys in PKCS#8 PrivateKeyInfo format (with files beginning ");
        System.err.println("-----BEGIN PRIVATE KEY----- or -----BEGIN ENCRYPTED PRIVATE KEY-----).");
        System.err.println();
        System.err.println("If input and/or output filename is omitted or -, the utility will use standard");
        System.err.println("input and/or output.");
        System.err.println();
        System.err.println("The -passin option argument will be used to decrypt an input encrypted private");
        System.err.println("key.  If absent the utility will ask the user for a passphrase.");
        System.err.println();
        System.err.println("If the -crypt option is given with a private key, the utility will encrypt any");
        System.err.println("private key output using the -passout option argument (if present) or using a");
        System.err.println("passphrase obtained by asking the user.");
    }

    KeyConverter(byte[] bytes, boolean encrypt) {
        this.bytes = bytes;
        this.encrypt = encrypt;
    }

    public KeyConverter(byte[] bytes, boolean encrypt, String outputFilename, byte[] passIn, byte[] passOut) {
        this.bytes = bytes;
        this.encrypt = encrypt;
        this.outputFilename = outputFilename;
        this.passIn = passIn;
        this.passOut = passOut;
    }

    byte[] getPassIn() throws Exception {
        if (this.passIn != null) {
            return this.passIn;
        }
        return Util.getPassphrase("Enter the passphrase to decrypt the input private key: ");
    }

    byte[] getPassOut() throws Exception {
        byte[] secKey2;
        byte[] secKey;
        if (this.passOut != null) {
            return this.passOut;
        }
        while (!Util.equals(secKey = Util.getPassphrase("\nPlease enter the passphrase to encrypt the output private key: "), secKey2 = Util.getPassphrase("\nPlease re-enter the private key passphrase: "))) {
            System.err.println("\nPassphrases do not match!  Try again.\n");
        }
        return secKey;
    }

    private static void convert(String inputFilename, String outputFilename, boolean encrypt, byte[] passIn, byte[] passOut) throws Exception {
        byte[] bytes;
        if (inputFilename == null) {
            bytes = StreamUtil.readFully((InputStream)System.in);
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFilename));){
                bytes = StreamUtil.readFully((InputStream)in);
            }
        }
        new KeyConverter(bytes, encrypt, outputFilename, passIn, passOut).convert();
    }

    void convert() throws Exception {
        if (Util.looksLikeBinary(this.bytes)) {
            this.convertFromHs();
        } else {
            this.convertToHs();
        }
    }

    private static boolean isPrivateKey(byte[] bytes) {
        int firstInt = Encoder.readInt(bytes, 0);
        return firstInt < 9;
    }

    private void convertFromHs() throws Exception {
        if (KeyConverter.isPrivateKey(this.bytes)) {
            byte[] secKey = null;
            if (Util.requiresSecretKey(this.bytes)) {
                secKey = this.getPassIn();
            }
            byte[] keyBytes = Util.decrypt(this.bytes, secKey);
            PrivateKey privateKey = Util.getPrivateKeyFromBytes(keyBytes);
            if (!this.encrypt) {
                this.sendOutput(KeyConverter.toPkcs8UnencryptedPem(privateKey));
            } else {
                secKey = this.getPassOut();
                this.sendOutput(KeyConverter.toPkcs8EncryptedPem(privateKey, Util.decodeString(secKey)));
            }
        } else {
            PublicKey publicKey = Util.getPublicKeyFromBytes(this.bytes);
            this.sendOutput(KeyConverter.toX509Pem(publicKey));
        }
    }

    private void convertToHs() throws Exception {
        String string = new String(this.bytes, "UTF-8");
        BytesAndKeyType bytesAndKeyType = KeyConverter.readPemFile(new StringReader(string));
        byte[] bytes = bytesAndKeyType.bytes;
        if ("PUBLIC".equals(bytesAndKeyType.keyType)) {
            PublicKey pubKey = KeyConverter.publicKeyFromBytes(bytes);
            byte[] outputBytes = Util.getBytesFromPublicKey(pubKey);
            this.sendOutput(outputBytes);
        } else {
            boolean encryptedInput = "ENCRYPTED PRIVATE".equals(bytesAndKeyType.keyType);
            if (!encryptedInput && !"PRIVATE".equals(bytesAndKeyType.keyType)) {
                throw new Exception("Unrecognized input file");
            }
            String passphrase = null;
            if (encryptedInput) {
                byte[] secKey = this.getPassIn();
                passphrase = Util.decodeString(secKey);
            }
            PrivateKey privateKey = KeyConverter.privateKeyFromBytes(bytes, encryptedInput, passphrase);
            if (!this.encrypt) {
                this.sendOutput(Util.encrypt(Util.getBytesFromPrivateKey(privateKey), null, 1));
            } else {
                byte[] secKey = this.getPassOut();
                this.sendOutput(Util.encrypt(Util.getBytesFromPrivateKey(privateKey), secKey));
            }
        }
    }

    void sendOutput(String string) throws Exception {
        if (this.outputFilename == null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            writer.write(string);
            ((Writer)writer).flush();
        } else {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFilename), "UTF-8"));){
                writer.write(string);
            }
        }
    }

    void sendOutput(byte[] bytes) throws Exception {
        if (this.outputFilename == null) {
            BufferedOutputStream out = new BufferedOutputStream(System.out);
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).flush();
        } else {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.outputFilename));){
                ((OutputStream)out).write(bytes);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String outputFilename;
        SimpleCommandLine commandLine = new SimpleCommandLine(new String[]{"o", "output", "passin", "passout"});
        commandLine.parse(args);
        if (commandLine.hasOption("h") || commandLine.hasOption("help")) {
            KeyConverter.printUsageAndExit();
            return;
        }
        boolean encrypt = commandLine.hasOption("crypt");
        String passInString = commandLine.getOptionArgument("passin");
        byte[] passIn = null;
        if (passInString != null) {
            passIn = Util.encodeString(passInString);
        }
        String passOutString = commandLine.getOptionArgument("passout");
        byte[] passOut = null;
        if (passOutString != null) {
            passOut = Util.encodeString(passOutString);
        }
        if ((outputFilename = commandLine.getOptionArgument("output")) == null) {
            outputFilename = commandLine.getOptionArgument("o");
        }
        if (outputFilename == null && commandLine.getOperands().size() >= 2) {
            outputFilename = (String)commandLine.getOperands().get(1);
        }
        if ("-".equals(outputFilename)) {
            outputFilename = null;
        }
        String inputFilename = null;
        if (!commandLine.getOperands().isEmpty()) {
            inputFilename = (String)commandLine.getOperands().get(0);
        }
        if ("-".equals(inputFilename)) {
            inputFilename = null;
        }
        KeyConverter.convert(inputFilename, outputFilename, encrypt, passIn, passOut);
    }

    private static class BytesAndKeyType {
        byte[] bytes;
        String keyType;

        public BytesAndKeyType(byte[] bytes, String keyType) {
            this.bytes = bytes;
            this.keyType = keyType;
        }
    }
}

