/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class HomeNA {
    public static void main(String[] argv) {
        if (argv.length < 6) {
            System.err.println("usage: java net.handle.apps.simple.HomeNA <auth hdl> <auth index> <privkey> <server ip> <server tcp port> <NA handle1> [<NA handle2>...]");
            System.exit(-1);
        }
        String authHdl = argv[0];
        int authIndex = Integer.parseInt(argv[1]);
        String privKeyFile = argv[2];
        String serverIp = argv[3];
        int port = Integer.parseInt(argv[4]);
        String[] nas = new String[argv.length - 5];
        System.arraycopy(argv, 5, nas, 0, nas.length);
        byte[] key = null;
        try {
            File f = new File(privKeyFile);
            try (FileInputStream fs = new FileInputStream(f);){
                key = Util.getBytesFromInputStream(fs);
            }
        }
        catch (Throwable t) {
            System.err.println("Cannot read private key " + privKeyFile + ": " + t);
            System.exit(-1);
        }
        HandleResolver resolver = new HandleResolver();
        resolver.traceMessages = true;
        PrivateKey privkey = null;
        byte[] secKey = null;
        try {
            if (Util.requiresSecretKey(key)) {
                secKey = Util.getPassphrase("passphrase: ");
            }
            key = Util.decrypt(key, secKey);
            privkey = Util.getPrivateKeyFromBytes(key, 0);
        }
        catch (Throwable t) {
            System.err.println("Can't load private key in " + privKeyFile + ": " + t);
            System.exit(-1);
        }
        try {
            PublicKeyAuthenticationInfo auth = new PublicKeyAuthenticationInfo(authHdl.getBytes("UTF8"), authIndex, privkey);
            InetAddress svrAddr = InetAddress.getByName(serverIp);
            GenericRequest siReq = new GenericRequest(Common.BLANK_HANDLE, 2, null);
            AbstractResponse response = resolver.sendHdlTcpRequest(siReq, svrAddr, port);
            SiteInfo siteInfo = null;
            if (response == null || response.responseCode != 1) {
                throw new Exception("Unable to retrieve site information from server");
            }
            siteInfo = ((GetSiteInfoResponse)response).siteInfo;
            if (!siteInfo.isPrimary) {
                throw new Exception("Given server is not a primary server.");
            }
            resolver.setCheckSignatures(true);
            resolver.traceMessages = true;
            for (int naIdx = 0; naIdx < nas.length; ++naIdx) {
                GenericRequest req = new GenericRequest(Util.encodeString(nas[naIdx]), 300, auth);
                req.majorProtocolVersion = (byte)2;
                req.minorProtocolVersion = 0;
                req.certify = true;
                req.isAdminRequest = true;
                for (int i = 0; i < siteInfo.servers.length; ++i) {
                    response = resolver.sendRequestToServer((AbstractRequest)req, siteInfo, siteInfo.servers[i]);
                    if (response.responseCode == 1) continue;
                    throw new Exception(String.valueOf(response));
                }
            }
        }
        catch (Throwable t) {
            System.err.println("\nError: " + t);
        }
    }
}

