/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class HDLList
implements ResponseMessageCallback {
    HandleResolver resolver = new HandleResolver();
    boolean showValues = false;

    public static void main(String[] argv) {
        if (argv.length != 4 && argv.length != 5) {
            System.err.println("usage: java net.handle.apps.simple.HDLList [-s] <auth handle> <auth index> <privkey> <prefix>");
            System.err.println("use option -s to list all handle values");
            System.exit(-1);
        }
        HDLList h = new HDLList(argv);
    }

    public HDLList(String[] argv) {
        SiteInfo[] sites;
        if (argv.length > 4) {
            String[] newargv = new String[argv.length - 1];
            int newindex = 0;
            for (int i = 0; i < argv.length; ++i) {
                if ("-s".equals(argv[i])) {
                    this.showValues = true;
                    continue;
                }
                newargv[newindex++] = argv[i];
            }
            argv = newargv;
        }
        byte[] key = null;
        try {
            File f = new File(argv[2]);
            try (FileInputStream fs = new FileInputStream(f);){
                key = Util.getBytesFromInputStream(fs);
            }
        }
        catch (Throwable t) {
            System.err.println("Cannot read private key " + argv[2] + ": " + t);
            System.exit(-1);
        }
        this.resolver.traceMessages = true;
        PrivateKey privkey = null;
        byte[] secKey = null;
        try {
            if (Util.requiresSecretKey(key)) {
                secKey = Util.getPassphrase("passphrase: ");
            }
            key = Util.decrypt(key, secKey);
            privkey = Util.getPrivateKeyFromBytes(key, 0);
        }
        catch (Throwable t) {
            System.err.println("Can't load private key in " + argv[2] + ": " + t);
            System.exit(-1);
        }
        ResolutionRequest resReq = new ResolutionRequest(Util.encodeString(argv[3] + "/test"), null, null, null);
        System.err.println("finding local sites for " + resReq);
        try {
            sites = this.resolver.findLocalSites(resReq);
        }
        catch (HandleException e) {
            e.printStackTrace();
            return;
        }
        PublicKeyAuthenticationInfo auth = new PublicKeyAuthenticationInfo(Util.encodeString(argv[0]), Integer.valueOf(argv[1]), privkey);
        ListHandlesRequest req = new ListHandlesRequest(Util.convertSlashlessHandleToZeroNaHandle(Util.encodeString(argv[3])), auth);
        for (int i = 0; i < sites[0].servers.length; ++i) {
            try {
                ServerInfo server = sites[0].servers[i];
                this.resolver.sendRequestToServer(req, sites[0], server, this);
                continue;
            }
            catch (Throwable t) {
                System.err.println("\nHDLError: " + t);
            }
        }
    }

    @Override
    public void handleResponse(AbstractResponse response) {
        this.resolver.traceMessages = false;
        if (response instanceof ListHandlesResponse) {
            try {
                ListHandlesResponse lhResp = (ListHandlesResponse)response;
                byte[][] handles = lhResp.handles;
                for (int i = 0; i < handles.length; ++i) {
                    String sHandle = Util.decodeString(handles[i]);
                    if (this.showValues) {
                        System.out.println();
                    }
                    System.out.println(sHandle);
                    if (!this.showValues) continue;
                    try {
                        HandleValue[] values = this.resolver.resolveHandle(sHandle);
                        for (int j = 0; j < values.length; ++j) {
                            System.out.println(values[j]);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error: " + e);
                e.printStackTrace(System.err);
            }
        } else if (response.responseCode != 402) {
            System.err.println(response);
        }
    }
}

