/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy.handlers;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CIDRUtils {
    private final String cidr;
    private InetAddress inetAddress;
    private InetAddress startAddress;
    private InetAddress endAddress;
    private final int prefixLength;
    private BigInteger start;
    private BigInteger end;

    public CIDRUtils(String cidr) throws UnknownHostException {
        this.cidr = cidr;
        if (this.cidr.contains("/")) {
            int index = this.cidr.indexOf("/");
            String addressPart = this.cidr.substring(0, index);
            String networkPart = this.cidr.substring(index + 1);
            this.inetAddress = InetAddress.getByName(addressPart);
            this.prefixLength = Integer.parseInt(networkPart);
            this.calculate();
        } else {
            this.inetAddress = InetAddress.getByName(this.cidr);
            this.prefixLength = this.inetAddress.getAddress().length * 8;
            this.calculate();
        }
    }

    private void calculate() throws UnknownHostException {
        int targetSize;
        ByteBuffer maskBuffer;
        if (this.inetAddress.getAddress().length == 4) {
            maskBuffer = ByteBuffer.allocate(4).putInt(-1);
            targetSize = 4;
        } else {
            maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
            targetSize = 16;
        }
        BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(this.prefixLength);
        ByteBuffer buffer = ByteBuffer.wrap(this.inetAddress.getAddress());
        BigInteger ipVal = new BigInteger(1, buffer.array());
        BigInteger startIp = ipVal.and(mask);
        BigInteger endIp = startIp.add(mask.not());
        byte[] startIpArr = CIDRUtils.toBytes(startIp.toByteArray(), targetSize);
        byte[] endIpArr = CIDRUtils.toBytes(endIp.toByteArray(), targetSize);
        this.startAddress = InetAddress.getByAddress(startIpArr);
        this.endAddress = InetAddress.getByAddress(endIpArr);
        this.start = new BigInteger(1, this.startAddress.getAddress());
        this.end = new BigInteger(1, this.endAddress.getAddress());
    }

    private static byte[] toBytes(byte[] array, int targetSize) {
        ArrayList<Byte> newArr = new ArrayList<Byte>();
        for (int counter = 0; counter < targetSize && array.length - 1 - counter >= 0; ++counter) {
            newArr.add(0, array[array.length - 1 - counter]);
        }
        int size = newArr.size();
        for (int i = 0; i < targetSize - size; ++i) {
            newArr.add(0, (byte)0);
        }
        byte[] ret = new byte[newArr.size()];
        for (int i = 0; i < newArr.size(); ++i) {
            ret[i] = (Byte)newArr.get(i);
        }
        return ret;
    }

    public String getNetworkAddress() {
        return this.startAddress.getHostAddress();
    }

    public String getBroadcastAddress() {
        return this.endAddress.getHostAddress();
    }

    public boolean isInRange(String ipAddress) throws UnknownHostException {
        return this.isInRange(CIDRUtils.asBigInteger(ipAddress));
    }

    public static BigInteger asBigInteger(String ipAddress) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(ipAddress);
        BigInteger target = new BigInteger(1, address.getAddress());
        return target;
    }

    public boolean isInRange(BigInteger target) {
        int st = this.start.compareTo(target);
        if (st == 1) {
            return false;
        }
        int te = target.compareTo(this.end);
        return te != 1;
    }
}

