/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.cnri.simplexml.XTag;
import net.cnri.util.FastDateFormat;
import net.cnri.util.ServletUtil;
import net.cnri.util.StreamTable;
import net.cnri.util.StreamVector;
import net.cnri.util.StringUtils;
import net.handle.apps.servlet_proxy.HDLServletRequest;
import net.handle.apps.servlet_proxy.HTMLFile;
import net.handle.apps.servlet_proxy.RotatingAccessLog;
import net.handle.apps.servlet_proxy.TypeHandler;
import net.handle.apps.servlet_proxy.handlers.CIDRUtils;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.MemCache;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.RequestProcessor;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.JwtClaimsSet;
import net.handle.hdllib.trust.TrustException;
import net.handle.server.MonitorDaemon;
import net.handle.server.servletcontainer.HandleServerInterface;
import net.handle.server.servletcontainer.servlets.BaseHandleRequestProcessingServlet;
import net.handle.server.servletcontainer.servlets.HandleJsonRestApiServlet;
import net.handle.server.servletcontainer.servlets.NativeServlet;
import net.handle.server.servletcontainer.servlets.UnknownApiServlet;
import net.handle.server.servletcontainer.support.PreAuthenticatedRequestProcessor;

public class HDLProxy
extends HttpServlet {
    public static final String ACTION_PARAM = "action";
    public static final String ACTION_REDIRECT = "redirect";
    public static final String ACTION_SHOWLOCS = "showurls";
    public static final String ACTION_SHOWVALUES = "showvalues";
    public static final String ACTION_TOOLBAR = "toolbar";
    public static final String ACTION_METADATA = "metadata";
    public static final String ACTION_REST = "api";
    public static final int MAX_ALIASES = 20;
    private final String DEFAULT_CONTACT_EMAIL = "hdladmin@cnri.reston.va.us";
    public static final byte[] MSG_INVALID_MSG_SIZE = Util.encodeString("Invalid message length");
    public static final byte[] MSG_INVALID_REQUEST = Util.encodeString("Invalid request");
    Map<String, String> handleLinkPrefixMap = new HashMap<String, String>();
    protected String HTDOCS = "";
    public static final Object resolverInitLock = new Object();
    public static RequestProcessor resolver = null;
    private static MemCache memCache;
    protected static final NamespaceInfo DEFAULT_NAMESPACE_INFO;
    private HandleServerInterface handleServer;
    private final FastDateFormat dateFormat = new FastDateFormat(new FastDateFormat.FormatSpec("-", " ", ":", "", ".", true, true), TimeZone.getDefault());
    protected Properties config;
    private RotatingAccessLog logger;
    private boolean logReferrer = false;
    private boolean logHSAdmin = false;
    private boolean logUserAgent = false;
    private String favicon = null;
    private String robotsTxt = null;
    private final String defaultAction = "redirect";
    protected TypeHandler[] valueHandlers = new TypeHandler[0];
    Hashtable<String, HTMLFile> queryPages = new Hashtable();
    Hashtable<String, HTMLFile> helpPages = new Hashtable();
    protected Hashtable<String, HTMLFile> errorPages = new Hashtable();
    Hashtable<String, HTMLFile> responsePages = new Hashtable();
    Hashtable<String, HTMLFile> valuesNotFoundPages = new Hashtable();
    Map<String, String> helpRedirect = new HashMap<String, String>();
    Map<String, Boolean> retryAuthOnNotFound = new HashMap<String, Boolean>();
    Map<String, List<String>> locattShortcutParameters = new HashMap<String, List<String>>();
    String remoteAddressHeader;
    List<CIDRUtils> remoteAddressInternalProxies;
    protected volatile boolean loadedSettings = false;
    private static final String VIRTUAL_HOST_HOSTNAME = "hostname";
    private static final Pattern commaSeparatedValuesPattern;

    public synchronized void destroy() {
        this.loadedSettings = false;
        if (this.logger != null) {
            this.logger.shutdown();
        }
        if (memCache != null) {
            memCache.close();
        }
        this.logger = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettings() throws ServletException {
        if (this.loadedSettings) {
            return;
        }
        Object object = resolverInitLock;
        synchronized (object) {
            if (this.loadedSettings) {
                return;
            }
            if (this.handleServer == null) {
                System.err.println("initializing Handle proxy servlet");
                ServletConfig slConfig = this.getServletConfig();
                System.err.println("  servlet config: ");
                Enumeration en = slConfig.getInitParameterNames();
                while (en.hasMoreElements()) {
                    String string = (String)en.nextElement();
                    System.err.println("   " + string + ": " + slConfig.getInitParameter(String.valueOf(string)));
                }
                ServletContext slContext = slConfig.getServletContext();
                System.err.println("  context config: ");
                Enumeration enumeration = slContext.getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    System.err.println("   " + name + ": " + slContext.getInitParameter(String.valueOf(name)));
                }
            }
            this.config = HDLProxy.loadHdlProxyProperties(this.getServletContext(), this.getServletConfig(), this.handleServer == null);
            this.HTDOCS = this.config.getProperty("htdocs");
            this.favicon = this.config.getProperty("favicon", null);
            if (this.favicon == null) {
                String faviconURL = this.config.getProperty("favicon_url", null);
                if (faviconURL != null) {
                    this.favicon = "redirect:" + faviconURL.trim();
                }
            } else {
                this.favicon = this.favicon.trim();
            }
            this.robotsTxt = this.config.getProperty("robots_txt", null);
            this.robotsTxt = this.robotsTxt == null ? "res:resources/robots.txt" : this.robotsTxt.trim();
            this.handleLinkPrefixMap.put("default", this.config.getProperty("handle_link_prefix"));
            if (this.handleServer == null) {
                try {
                    String logFileName = this.config.getProperty("access_log");
                    if (logFileName != null) {
                        File logDir = new File(logFileName).getParentFile();
                        System.err.println("loading logger for handle proxy");
                        System.err.println(" log folder: " + logDir.getAbsolutePath());
                        String string = this.config.getProperty("log_rotation_rate", "monthly");
                        RotatingAccessLog.RotationRate rate = "daily".equalsIgnoreCase(string) ? RotatingAccessLog.RotationRate.ROTATE_DAILY : ("hourly".equalsIgnoreCase(string) ? RotatingAccessLog.RotationRate.ROTATE_HOURLY : ("never".equalsIgnoreCase(string) ? RotatingAccessLog.RotationRate.ROTATE_NEVER : RotatingAccessLog.RotationRate.ROTATE_MONTHLY));
                        this.logger = RotatingAccessLog.getLogger(logDir, rate);
                        MonitorDaemon monitorDaemon = (MonitorDaemon)this.getServletContext().getAttribute(MonitorDaemon.class.getName());
                        if (monitorDaemon != null) {
                            monitorDaemon.setRequestCounters(this.logger.getRequestsPastMinute(), this.logger.getPeakRequestsPerMinute());
                        }
                    }
                }
                catch (Exception e) {
                    throw new ServletException("Error loading logger", (Throwable)e);
                }
            }
            this.remoteAddressHeader = this.config.getProperty("remote_address_header");
            String remoteAddressInternalProxiesString = this.config.getProperty("remote_address_internal_proxies");
            if (remoteAddressInternalProxiesString != null) {
                String[] proxyStrings = remoteAddressInternalProxiesString.split("\\s*,\\s*");
                this.remoteAddressInternalProxies = new ArrayList<CIDRUtils>();
                for (String proxyString : proxyStrings) {
                    try {
                        this.remoteAddressInternalProxies.add(new CIDRUtils(proxyString));
                    }
                    catch (UnknownHostException e) {
                        throw new ServletException("Error parsing remote_address_internal_proxies", (Throwable)e);
                    }
                }
            }
            this.logReferrer = Boolean.valueOf(this.config.getProperty("log_referrer", "true"));
            this.logHSAdmin = Boolean.valueOf(this.config.getProperty("log_hs_admin", "false"));
            this.logUserAgent = Boolean.valueOf(this.config.getProperty("log_user_agent", "true"));
            TreeSet<TypeHandlerEntry> handlers = new TreeSet<TypeHandlerEntry>((o1, o2) -> o1.position - o2.position);
            this.retryAuthOnNotFound.put("default", Boolean.valueOf(this.config.getProperty("retry_auth_on_not_found", "false")));
            StringTokenizer stringTokenizer = new StringTokenizer(this.config.getProperty("locatt_shortcut_parameters", ""));
            ArrayList<String> locattParams = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                locattParams.add(stringTokenizer.nextToken());
            }
            this.locattShortcutParameters.put("default", locattParams);
            Enumeration<?> enumeration = this.config.propertyNames();
            while (enumeration.hasMoreElements()) {
                String host;
                String prop = (String)enumeration.nextElement();
                if (prop.startsWith("typehandler.")) {
                    TypeHandlerEntry entry = new TypeHandlerEntry();
                    String klass = this.config.getProperty(prop);
                    try {
                        String pos = prop.substring("typehandler.".length());
                        entry.position = Integer.parseInt(pos);
                        entry.handler = (TypeHandler)Class.forName(klass).getConstructor(new Class[0]).newInstance(new Object[0]);
                        handlers.add(entry);
                    }
                    catch (Exception e) {
                        System.err.println("Error setting " + prop + " = " + klass + ": " + e);
                    }
                    continue;
                }
                if (prop.startsWith("query-page.")) {
                    try {
                        host = prop.substring("query-page.".length()).toLowerCase();
                        String file = this.config.getProperty(prop).trim();
                        this.queryPages.put(host, new HTMLFile(this.HTDOCS, file, this.getServletContext()));
                    }
                    catch (Exception e) {
                        System.err.println("Error setting query page: " + prop + "\n");
                        e.printStackTrace();
                    }
                    continue;
                }
                if (prop.startsWith("help-page.")) {
                    try {
                        host = prop.substring("help-page.".length()).toLowerCase();
                        String file = this.config.getProperty(prop).trim();
                        this.helpPages.put(host, new HTMLFile(this.HTDOCS, file, this.getServletContext()));
                    }
                    catch (Exception e) {
                        System.err.println("Error setting help page: " + prop + "\n" + e);
                    }
                    continue;
                }
                if (prop.startsWith("response-page.")) {
                    try {
                        host = prop.substring("response-page.".length()).toLowerCase();
                        String file = this.config.getProperty(prop).trim();
                        this.responsePages.put(host, new HTMLFile(this.HTDOCS, file, this.getServletContext()));
                    }
                    catch (Exception e) {
                        System.err.println("Error setting response page: " + prop);
                    }
                    continue;
                }
                if (prop.startsWith("novalues-page.")) {
                    try {
                        host = prop.substring("novalues-page.".length()).toLowerCase();
                        String file = this.config.getProperty(prop).trim();
                        this.valuesNotFoundPages.put(host, new HTMLFile(this.HTDOCS, file, this.getServletContext()));
                    }
                    catch (Exception e) {
                        System.err.println("Error setting valuesnotfound page: " + prop);
                    }
                    continue;
                }
                if (prop.startsWith("error-page.")) {
                    try {
                        host = prop.substring("error-page.".length()).toLowerCase();
                        String file = this.config.getProperty(prop).trim();
                        this.errorPages.put(host, new HTMLFile(this.HTDOCS, file, this.getServletContext()));
                    }
                    catch (Exception e) {
                        System.err.println("Error setting error page: " + prop);
                    }
                    continue;
                }
                if (prop.startsWith("retry_auth_on_not_found.")) {
                    host = prop.substring("retry_auth_on_not_found.".length()).toLowerCase();
                    boolean val = Boolean.valueOf(this.config.getProperty(prop));
                    this.retryAuthOnNotFound.put(host, val);
                    continue;
                }
                if (prop.startsWith("handle_link_prefix.")) {
                    host = prop.substring("handle_link_prefix.".length()).toLowerCase();
                    this.handleLinkPrefixMap.put(host, this.config.getProperty(prop).trim());
                    continue;
                }
                if (prop.startsWith("locatt_shortcut_params.")) {
                    host = prop.substring("locatt_shortcut_params.".length()).toLowerCase();
                    StringTokenizer st2 = new StringTokenizer(this.config.getProperty(prop, ""));
                    ArrayList<String> locattParams2 = new ArrayList<String>();
                    while (st2.hasMoreTokens()) {
                        locattParams2.add(st2.nextToken());
                    }
                    this.locattShortcutParameters.put(host, locattParams2);
                    continue;
                }
                if (!prop.startsWith("help_redirect.")) continue;
                String redirect = prop.substring("help_redirect.".length()).toLowerCase();
                this.helpRedirect.put(redirect, this.config.getProperty(prop).trim());
            }
            this.valueHandlers = new TypeHandler[handlers.size()];
            Iterator iterator = handlers.iterator();
            for (int i = 0; i < this.valueHandlers.length; ++i) {
                this.valueHandlers[i] = ((TypeHandlerEntry)iterator.next()).handler;
            }
            Object object2 = resolverInitLock;
            synchronized (object2) {
                if (resolver == null) {
                    if (this.handleServer == null) {
                        resolver = new HandleResolver();
                        ((HandleResolver)HDLProxy.resolver).traceMessages = this.config.getProperty("trace_msgs", "false").equals("true");
                        this.initResolver();
                    } else {
                        resolver = new PreAuthenticatedRequestProcessor(this.handleServer, "HDLProxy");
                    }
                }
            }
            this.loadedSettings = true;
        }
    }

    public static Properties loadHdlProxyProperties(ServletContext context, ServletConfig config, boolean logConfig) throws ServletException {
        Properties res = new Properties();
        try {
            String configFileStr = null;
            if (config != null) {
                configFileStr = config.getInitParameter("config");
            }
            if (logConfig) {
                System.err.println("  base path: " + new File(".").getCanonicalPath());
                System.err.println("  config file: " + configFileStr);
            }
            File configFile = null;
            if (configFileStr != null) {
                configFile = new File(configFileStr);
            }
            if (configFile != null && configFile.exists() && configFile.canRead()) {
                if (logConfig) {
                    System.err.println("Loading settings from " + configFile.getCanonicalPath());
                }
                FileInputStream in = new FileInputStream(configFile);
                res.load(in);
                ((InputStream)in).close();
            } else {
                InputStream in = context.getResourceAsStream("/WEB-INF/hdlproxy.properties");
                if (in != null) {
                    if (logConfig) {
                        System.err.println("Loading settings from /WEB-INF/hdlproxy.properties");
                    }
                    res.load(in);
                    in.close();
                } else {
                    if (logConfig) {
                        System.err.println("Loading default settings");
                    }
                    res.load(HDLProxy.class.getResourceAsStream("resources/WEB-INF/hdlproxy.properties"));
                }
            }
        }
        catch (IOException e) {
            throw new ServletException("Error loading servlet properties: " + e);
        }
        return res;
    }

    public void initResolver() {
        if (resolver instanceof HandleResolver) {
            memCache = new MemCache(16384, 3600L, true);
            ((HandleResolver)resolver).setCache(memCache);
        }
    }

    private void handleFavicon(HttpServletResponse resp) throws IOException {
        this.handleSpecial(resp, this.favicon, "image/x-icon");
    }

    private void handleRobotsTxt(HttpServletResponse resp) throws IOException {
        this.handleSpecial(resp, this.robotsTxt, "text/plain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSpecial(HttpServletResponse resp, String configValue, String contentType) throws IOException {
        if (configValue.startsWith("redirect:")) {
            String faviconURL = configValue.substring("redirect:".length());
            resp.setStatus(301);
            resp.setDateHeader("Expires", System.currentTimeMillis() + 604800000L);
            resp.setHeader("Location", faviconURL);
            try {
                resp.getWriter().write("Favicon moved to " + faviconURL);
            }
            catch (Exception exception) {}
        } else if (configValue.startsWith("servlet:")) {
            String path = configValue.substring("servlet:".length());
            InputStream in = this.getServletContext().getResourceAsStream(path);
            if (in == null) {
                resp.setStatus(404);
            } else {
                try {
                    resp.setStatus(200);
                    resp.setContentType(contentType);
                    HDLProxy.copyInputToOutput(in, (OutputStream)resp.getOutputStream());
                }
                finally {
                    in.close();
                }
            }
        } else if (configValue.startsWith("res:")) {
            String path = configValue.substring("res:".length());
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(path);
            if (in == null) {
                resp.setStatus(404);
            } else {
                try {
                    resp.setStatus(200);
                    resp.setContentType(contentType);
                    HDLProxy.copyInputToOutput(in, (OutputStream)resp.getOutputStream());
                }
                finally {
                    in.close();
                }
            }
        } else {
            File file = new File(configValue);
            if (!file.exists()) {
                resp.setStatus(404);
            } else {
                try (FileInputStream in = new FileInputStream(configValue);){
                    resp.setStatus(200);
                    resp.setContentType(contentType);
                    HDLProxy.copyInputToOutput(in, (OutputStream)resp.getOutputStream());
                }
            }
        }
    }

    private static void copyInputToOutput(InputStream in, OutputStream out) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = in.read(buf)) > 0) {
            out.write(buf, 0, r);
        }
    }

    public void init() throws ServletException {
        this.handleServer = (HandleServerInterface)this.getServletContext().getAttribute("net.handle.server.HandleServer");
        this.loadSettings();
        if (this.handleServer != null) {
            this.legacyHandleServerInit();
            this.otherHandleServerInit();
        }
        this.getServletContext().setAttribute(HDLProxy.class.getName(), (Object)this);
        if (resolver instanceof HandleResolver) {
            this.getServletContext().setAttribute(HandleResolver.class.getName(), (Object)resolver);
        }
    }

    private void legacyHandleServerInit() {
        String dir = this.handleServer.getConfigDir().getAbsolutePath();
        Vector labels = (Vector)this.handleServer.getConfig().get("interfaces");
        for (String label : labels) {
            if (!label.startsWith("hdl_http")) continue;
            StreamTable intfConfig = (StreamTable)this.handleServer.getConfig().get(label + "_config");
            this.addPage(intfConfig, this.queryPages, dir, "query_page", "default");
            this.addPage(intfConfig, this.responsePages, dir, "response_page", "default");
            this.addPage(intfConfig, this.errorPages, dir, "error_page", "default");
            this.addPage(intfConfig, this.valuesNotFoundPages, dir, "error_page", "default");
            Object ob = this.config.get("virtual_hosts");
            Vector<Hashtable> virtualHosts = null;
            if (ob instanceof Vector) {
                Vector<Hashtable> v;
                virtualHosts = v = (Vector<Hashtable>)ob;
            } else if (ob instanceof Hashtable) {
                Hashtable virtualHt = (Hashtable)ob;
                virtualHosts = new Vector<Hashtable>();
                virtualHosts.addElement(virtualHt);
            }
            for (int i = 0; virtualHosts != null && i < virtualHosts.size(); ++i) {
                Hashtable ht = (Hashtable)virtualHosts.elementAt(i);
                String hostname = (String)ht.get(VIRTUAL_HOST_HOSTNAME);
                if (hostname == null || hostname.length() == 0) {
                    System.err.println("The vitual host name missing in the configuration!");
                    continue;
                }
                this.addPage(intfConfig, this.queryPages, dir, "query_page", hostname);
                this.addPage(intfConfig, this.responsePages, dir, "response_page", hostname);
                this.addPage(intfConfig, this.errorPages, dir, "error_page", hostname);
                this.addPage(intfConfig, this.valuesNotFoundPages, dir, "error_page", hostname);
            }
        }
    }

    private void addPage(StreamTable whichConfig, Hashtable<String, HTMLFile> pages, String dir, String param, String hostname) {
        String page = (String)whichConfig.get(param);
        if (page != null) {
            try {
                pages.put(hostname, new HTMLFile(dir, page.trim(), this.getServletContext()));
            }
            catch (Exception e) {
                System.err.println("Error adding " + param + page + " for " + hostname + "\n" + e);
            }
        }
    }

    private void otherHandleServerInit() throws ServletException {
        StreamTable serverConfig = (StreamTable)this.handleServer.getConfig().get("server_config");
        if (serverConfig == null) {
            return;
        }
        StreamTable httpConfig = (StreamTable)serverConfig.get("http_config");
        if (httpConfig == null) {
            return;
        }
        if (httpConfig.containsKey("favicon")) {
            this.favicon = httpConfig.getStr("favicon");
        }
        if (httpConfig.containsKey("robots_txt")) {
            this.robotsTxt = httpConfig.getStr("robots_txt");
        }
        if (httpConfig.containsKey("remote_address_header")) {
            this.remoteAddressHeader = httpConfig.getStr("remote_address_header");
        }
        if (httpConfig.containsKey("remote_address_internal_proxies")) {
            this.remoteAddressInternalProxies = new ArrayList<CIDRUtils>();
            StreamVector proxiesStreamVector = (StreamVector)httpConfig.get("remote_address_internal_proxies");
            for (Object proxyObj : proxiesStreamVector) {
                try {
                    this.remoteAddressInternalProxies.add(new CIDRUtils((String)proxyObj));
                }
                catch (UnknownHostException e) {
                    throw new ServletException("Couldn't parse remote_address_internal_proxies", (Throwable)e);
                }
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (this.handleSpecial(req, resp)) {
            return;
        }
        HDLServletRequest hdlReq = new HDLServletRequest(this, req, resp, resolver);
        this.doResponse(hdlReq);
    }

    protected boolean handleSpecial(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path;
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        String string = path = pathInfo == null ? servletPath : servletPath + pathInfo;
        if (this.favicon != null && path.startsWith("/favicon.ico")) {
            this.handleFavicon(resp);
            return true;
        }
        if (path.startsWith("/robots.txt")) {
            this.handleRobotsTxt(resp);
            return true;
        }
        return false;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String accept = req.getHeader("Accept");
        String contentType = req.getContentType();
        if (accept != null && accept.toUpperCase().indexOf("application/x-hdl-message".toUpperCase()) >= 0 && contentType != null && contentType.toUpperCase().contains("application/x-hdl-message".toUpperCase())) {
            RequestDispatcher dispatcher = this.getServletContext().getNamedDispatcher(NativeServlet.class.getName());
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            resp.setStatus(500);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/plain");
            resp.getWriter().println("Unable to dispatch native handle request");
            return;
        }
        HDLServletRequest hdl = new HDLServletRequest(this, req, resp, resolver);
        this.doResponse(hdl);
    }

    protected void doResponse(HDLServletRequest hdl) throws IOException, ServletException {
        if (hdl.hdl == null || hdl.hdl.length() <= 0) {
            this.returnQueryPage(hdl);
            return;
        }
        if (hdl.hdl.equals("help.html")) {
            this.returnHelpPage(hdl);
            return;
        }
        hdl.normalizeHandle();
        this.doResolution(hdl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doResolution(HDLServletRequest hdl, int aliasCount) throws IOException, ServletException {
        String action = hdl.params.getParameter(ACTION_PARAM);
        if (action == null && hdl.params.getParameter("noredirect") != null) {
            action = ACTION_SHOWVALUES;
        }
        if (action == null) {
            action = ACTION_REDIRECT;
        }
        action = action.toLowerCase();
        String extraString = "hdl:\"" + StringUtils.encodeURL((String)hdl.getUriPathAndParams()) + "\"";
        if (hdl.oldApi) {
            if (this.handleUnknownApi(hdl)) {
                return;
            }
            action = ACTION_SHOWVALUES;
        }
        if (hdl.api || ACTION_REST.equals(action)) {
            if (this.resolveRestfully(hdl)) {
                return;
            }
            action = ACTION_SHOWVALUES;
        }
        NamespaceInfo nsInfo = null;
        HandleValue[] vals = null;
        try {
            hdl.resolveHandle();
            if (!hdl.resRequest.authoritative && hdl.resResponse != null && hdl.resResponse.responseCode == 100) {
                Boolean retry = this.retryAuthOnNotFound.get(hdl.req.getServerName().toLowerCase());
                if (retry == null) {
                    retry = this.retryAuthOnNotFound.get("default");
                }
                if (retry == null) {
                    retry = Boolean.FALSE;
                }
                if (retry.booleanValue()) {
                    hdl.resolveHandle(hdl.resRequest.requestedTypes, hdl.resRequest.requestedIndexes, hdl.resRequest.ignoreRestrictedValues, true, hdl.resRequest.certify);
                }
            }
            nsInfo = hdl.resRequest.getNamespace();
            String msg = "";
            if (nsInfo != null && nsInfo.getNamespaceStatus().equals("inactive")) {
                msg = "Inactive Namespace";
                this.logAccess("HTTP:HDL", 1, 2, hdl, null, extraString);
                this.returnErrorPage(msg, hdl, nsInfo, null, 404);
                return;
            }
            if (hdl.resResponse == null || hdl.resResponse.responseCode != 1) {
                if (hdl.resResponse == null) {
                    msg = "Resolution Error";
                } else if (hdl.resResponse.responseCode == 100) {
                    msg = "Not Found";
                } else if (hdl.resResponse.responseCode == 200) {
                    msg = "No Values Found";
                    if (hdl.resRequest.requestedTypes != null && hdl.resRequest.requestedTypes.length > 0) {
                        this.logAccess("HTTP:HDL", 1, hdl.resResponse.responseCode, hdl, null, extraString);
                        this.returnValuesNotFoundPage(msg, hdl, null);
                        return;
                    }
                } else {
                    msg = "Resolution Error";
                }
                this.logAccess("HTTP:HDL", 1, hdl.resResponse.responseCode, hdl, null, extraString);
                this.returnErrorPage(msg, hdl, nsInfo, null, BaseHandleRequestProcessingServlet.statusCodeFromResponse(hdl.resResponse));
                return;
            }
            vals = ((ResolutionResponse)hdl.resResponse).getHandleValues();
        }
        catch (HandleException e) {
            if (nsInfo == null) {
                try {
                    nsInfo = hdl.resRequest.getNamespace();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String msg = "";
            if (e.getCode() == 2) {
                int index = hdl.hdl.indexOf("/");
                String na = index != -1 ? hdl.hdl.substring(0, index) : hdl.hdl;
                msg = "Prefix [" + na + "] Not Found";
            } else {
                msg = e.getCode() == 7 ? "Cannot Connect to Server" : "System Error";
            }
            this.logAccess("HTTP:HDL", 1, 2, hdl, null, extraString);
            hdl.exception = e;
            this.returnErrorPage(msg, hdl, nsInfo, null, BaseHandleRequestProcessingServlet.statusCodeFromResponse(e.toErrorResponse(hdl.resRequest)));
            return;
        }
        if (hdl.params.getParameter("ignore_aliases") == null) {
            for (HandleValue val : vals) {
                if (!val.hasType(Common.STD_TYPE_HSALIAS)) continue;
                if (aliasCount < 20) {
                    hdl.hdl = Util.decodeString(val.getData());
                    hdl.modifyExpiration(val);
                    this.doResolution(hdl, aliasCount + 1);
                    return;
                }
                this.returnErrorPage("Alias chain too long", hdl, nsInfo, null, 404);
                return;
            }
        }
        try {
            if (action.equals(ACTION_SHOWVALUES)) {
                this.returnResponsePage(hdl, vals);
            } else if (action.equals(ACTION_SHOWLOCS)) {
                this.doShowLocations(hdl, vals);
            } else if (aliasCount > 0 && (hdl.req.getMethod().equalsIgnoreCase("GET") || hdl.req.getMethod().equalsIgnoreCase("HEAD"))) {
                String path = hdl.hdl;
                String query = "";
                if (hdl.req.getQueryString() != null) {
                    query = "?" + hdl.req.getQueryString();
                }
                hdl.sendHTTPRedirect(HDLServletRequest.ResponseType.MOVED_PERMANENTLY, hdl.getURLForHandle(path, query));
            } else {
                this.doRedirect(hdl, vals);
            }
        }
        finally {
            this.logAccess("HTTP:HDL", 1, hdl.resResponse.responseCode, hdl, vals, extraString);
        }
    }

    private boolean handleUnknownApi(HDLServletRequest hdl) throws IOException, ServletException {
        RequestDispatcher dispatcher = this.getServletContext().getNamedDispatcher(UnknownApiServlet.class.getName());
        if (dispatcher != null) {
            dispatcher.forward((ServletRequest)hdl.req, (ServletResponse)hdl.response);
            return true;
        }
        return false;
    }

    private boolean resolveRestfully(final HDLServletRequest hdl) throws IOException, ServletException {
        RequestDispatcher dispatcher = this.getServletContext().getNamedDispatcher(HandleJsonRestApiServlet.class.getName());
        if (dispatcher != null) {
            HttpServletRequestWrapper req = new HttpServletRequestWrapper(hdl.req){
                private String requestURI;
                {
                    super(arg0);
                    this.requestURI = super.getContextPath() + super.getServletPath();
                    if (!this.requestURI.endsWith("/")) {
                        this.requestURI = this.requestURI + "/";
                    }
                    this.requestURI = this.requestURI + StringUtils.encodeURLPath((String)hdl.hdl);
                }

                public String getMethod() {
                    String method = super.getMethod();
                    if (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD")) {
                        return method;
                    }
                    return "GET";
                }

                public String getRequestURI() {
                    return this.requestURI;
                }
            };
            dispatcher.forward((ServletRequest)req, (ServletResponse)hdl.response);
            return true;
        }
        return false;
    }

    protected void doRedirect(HDLServletRequest hdl, HandleValue[] vals) throws IOException {
        for (TypeHandler handler : this.valueHandlers) {
            if (!handler.canRedirect(vals)) continue;
            try {
                if (!handler.doRedirect(hdl, vals)) continue;
                return;
            }
            catch (Exception e) {
                if (e.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                    throw (IOException)e;
                }
                if (e.getClass().getName().equals("org.eclipse.jetty.io.EofException")) {
                    throw (IOException)e;
                }
                this.logError(50, "Error showing redirect for '" + hdl.hdl + "': " + e);
                this.returnErrorPage("Error showing redirect for '" + hdl.hdl + "': " + e.getMessage(), hdl, null, null, 500);
                e.printStackTrace(System.err);
                return;
            }
        }
        this.returnResponsePage(hdl, vals);
    }

    protected void doShowLocations(HDLServletRequest hdl, HandleValue[] vals) throws IOException {
        for (TypeHandler handler : this.valueHandlers) {
            if (!handler.canShowLocations(vals)) continue;
            try {
                XTag locations = handler.doShowLocations(hdl, vals);
                if (locations == null || locations.getSubTagCount() <= 0) continue;
                hdl.response.setContentType("text/xml; charset=utf-8");
                locations.write((OutputStream)hdl.response.getOutputStream());
                return;
            }
            catch (Exception e) {
                this.logError(50, "Error showing locations for '" + hdl.hdl + "': " + e);
                this.returnErrorPage("Error showing locations for '" + hdl.hdl + "': " + e.getMessage(), hdl, null, null, 500);
                return;
            }
        }
        this.returnResponsePage(hdl, vals);
    }

    protected void returnErrorPage(String msg, HDLServletRequest hdl, NamespaceInfo nsInfo, String trace, int statusCode) throws IOException {
        this.returnErrorPage(msg, hdl, nsInfo, null, trace, statusCode);
    }

    private static String getContextPath(HDLServletRequest hdl) {
        return StringUtils.cgiEscape((String)ServletUtil.pathMatching((String)hdl.req.getRequestURI(), (String)hdl.req.getContextPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnValuesNotFoundPage(String msg, HDLServletRequest hdl, String trace) throws IOException {
        if (msg == null) {
            msg = "Requested Values Not Found";
        }
        if (trace == null) {
            trace = "";
        }
        HTMLFile f = null;
        try {
            f = this.valuesNotFoundPages.get(hdl.req.getServerName().toLowerCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (f == null) {
            f = this.valuesNotFoundPages.get("default");
        }
        if (f == null) {
            this.returnErrorPage(msg, hdl, null, trace, 200);
            return;
        }
        HTMLFile hTMLFile = f;
        synchronized (hTMLFile) {
            f.reset();
            f.setValue("CONTEXT_PATH", HDLProxy.getContextPath(hdl));
            f.setValue("HANDLE_URL", hdl.getURLForHandle(hdl.hdl));
            f.setValue("HANDLE", hdl.hdl);
            f.setValue("ERROR", msg);
            f.setValue("REFERER", hdl.getReferer());
            f.setValue("TRACE", trace);
            hdl.response.setContentType("text/html; charset=utf-8");
            f.output((OutputStream)hdl.response.getOutputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnErrorPage(String msg, HDLServletRequest hdl, NamespaceInfo nsInfo, String ref, String trace, int statusCode) throws IOException {
        hdl.response.setStatus(statusCode);
        if (msg == null) {
            msg = "Unknown error.";
        }
        if (trace == null) {
            trace = "";
        }
        HTMLFile f = null;
        try {
            f = this.errorPages.get(hdl.req.getServerName().toLowerCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (f == null) {
            f = this.errorPages.get("default");
        }
        if (f == null) {
            System.err.println("Error loading error page.");
            hdl.response.setContentType("text/plain");
            hdl.response.getWriter().println("Template page not found!\nError: " + msg);
            return;
        }
        HTMLFile hTMLFile = f;
        synchronized (hTMLFile) {
            String nsStatusMsg;
            f.reset();
            f.setValue("CONTEXT_PATH", HDLProxy.getContextPath(hdl));
            f.setValue("SERVER_ERROR", hdl.exception != null && hdl.exception.getCode() == 7 ? "Yes" : "No");
            boolean trailingSlash = hdl.hdl.endsWith("/");
            f.setValue("TRAILING_SLASH", trailingSlash ? "Yes" : "No");
            if (trailingSlash) {
                f.setValue("NOSLASH_HANDLE_URL", hdl.getURLForHandle(hdl.hdl.substring(0, hdl.hdl.length() - 1)));
            } else {
                f.setValue("NOSLASH_HANDLE_URL", hdl.getURLForHandle(hdl.hdl));
            }
            boolean prefixOnly = !hdl.hdl.contains("/") || hdl.hdl.indexOf(47) == hdl.hdl.length() - 1;
            f.setValue("PREFIX_ONLY", prefixOnly ? "Yes" : "No");
            if (nsInfo == null) {
                nsInfo = DEFAULT_NAMESPACE_INFO;
            }
            String contactAddr = this.getResponsiblePartyContactAddress(nsInfo, hdl);
            f.setValue("NS_CONTACT", contactAddr);
            f.setValue("DEFAULT_CONTACT", "hdladmin@cnri.reston.va.us");
            if (!"hdladmin@cnri.reston.va.us".equals(contactAddr)) {
                f.setValue("HAS_NS_CONTACT", "Yes");
            }
            if ((nsStatusMsg = this.getStatusMessage(hdl.hdl, nsInfo)) != null && nsStatusMsg.trim().length() > 0) {
                f.setValue("HAS_NS_STATUS_MSG", "Yes");
                f.setValue("NS_STATUS_MSG", nsStatusMsg);
            }
            f.setValue("NS_STATUS", nsInfo.getNamespaceStatus());
            f.setValue("HANDLE", hdl.hdl);
            f.setValue("ERROR", msg);
            f.setValue("REFERER", hdl.getReferer());
            f.setValue("TRACE", trace);
            try {
                hdl.response.setContentType("text/html; charset=utf-8");
                f.output((OutputStream)hdl.response.getOutputStream());
            }
            catch (Throwable t) {
                System.err.println("Error sending response: " + t);
                t.printStackTrace();
            }
        }
    }

    private String getResponsiblePartyContactAddress(NamespaceInfo nsInfo, HDLServletRequest request) {
        try {
            HandleValue[] prefixValues;
            String nsContactAddr = nsInfo.getResponsiblePartyContactAddress();
            if (nsContactAddr != null && !nsContactAddr.trim().isEmpty()) {
                return nsContactAddr.trim();
            }
            String prefix = Util.getZeroNAHandle(request.hdl);
            if ("0.NA/0.NA".equalsIgnoreCase(prefix)) {
                return "hdladmin@cnri.reston.va.us";
            }
            try {
                prefixValues = this.resolveHandle(prefix);
            }
            catch (HandleException e) {
                if (!Util.isSubNAHandle(prefix)) {
                    return "hdladmin@cnri.reston.va.us";
                }
                String prefixParent = this.getTopLevelPrefix(prefix);
                prefixValues = this.resolveHandle(prefixParent);
            }
            String prefixEmail = null;
            boolean usePrefixEmail = false;
            for (HandleValue value : prefixValues) {
                String valueType = value.getTypeAsString();
                if ("EMAIL".equalsIgnoreCase(valueType)) {
                    prefixEmail = value.getDataAsString();
                }
                if (!"HS_SIGNATURE".equalsIgnoreCase(valueType)) continue;
                String issuer = this.getIssuerHandleFromSignatureValue(value);
                if ("0.NA/0.NA".equalsIgnoreCase(issuer)) {
                    usePrefixEmail = true;
                    continue;
                }
                String email = this.getEmailFromHandleRecord(issuer);
                if (email == null) continue;
                return email.trim();
            }
            if (usePrefixEmail && prefixEmail != null) {
                return prefixEmail.trim();
            }
            return "hdladmin@cnri.reston.va.us";
        }
        catch (Exception e) {
            return "hdladmin@cnri.reston.va.us";
        }
    }

    private String getIssuerHandleFromSignatureValue(HandleValue value) throws TrustException {
        JsonWebSignatureFactory factory = JsonWebSignatureFactory.getInstance();
        Gson gson = GsonUtility.getGson();
        String sig = value.getDataAsString();
        JsonWebSignature jws = factory.deserialize(sig);
        JwtClaimsSet claims = (JwtClaimsSet)gson.fromJson(jws.getPayloadAsString(), JwtClaimsSet.class);
        return ValueReference.fromString(claims.iss).getHandleAsString();
    }

    private String getEmailFromHandleRecord(String issuer) throws HandleException {
        HandleValue[] issValues;
        for (HandleValue issValue : issValues = this.resolveHandle(issuer)) {
            if (!"EMAIL".equals(issValue.getTypeAsString())) continue;
            return issValue.getDataAsString();
        }
        return null;
    }

    private String getTopLevelPrefix(String prefix) {
        while (Util.isSubNAHandle(prefix)) {
            prefix = Util.getParentNAOfNAHandle(prefix);
        }
        return prefix;
    }

    private HandleValue[] resolveHandle(String handle) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        ResolutionRequest resolutionRequest = new ResolutionRequest(handleBytes, null, null, null);
        AbstractResponse response = resolver.processRequest(resolutionRequest, null);
        if (response.responseCode != 1) {
            throw new HandleException(1, response.toString());
        }
        if (response instanceof ResolutionResponse) {
            ResolutionResponse resResponse = (ResolutionResponse)response;
            return resResponse.getHandleValues();
        }
        throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode));
    }

    protected String getStatusMessage(String hdl, NamespaceInfo nsInfo) {
        String msg = nsInfo.getStatusMessage();
        if (msg != null) {
            return StringUtils.cgiEscape((String)msg.trim());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnResponsePage(HDLServletRequest hdl, HandleValue[] vals) throws IOException {
        if (vals != null && vals.length <= 0) {
            this.returnValuesNotFoundPage(null, hdl, null);
            return;
        }
        HTMLFile f = this.responsePages.get(hdl.req.getServerName().toLowerCase());
        if (f == null) {
            f = this.responsePages.get("default");
        }
        StringBuffer page = new StringBuffer();
        if (vals != null && vals.length > 0) {
            page.append("<tr><td align=\"left\" valign=\"top\">Index</td>");
            page.append("<td align=\"left\" valign=\"top\">Type</td>");
            page.append("<td align=\"left\" valign=\"top\">Timestamp");
            page.append("</td><td align=\"left\" valign=\"top\">Data</td>");
            page.append("</tr>\n");
            for (int i = 0; i < vals.length; ++i) {
                String dataStr;
                HandleValue val = vals[i];
                TypeHandler t = null;
                for (TypeHandler valueHandler : this.valueHandlers) {
                    if (!valueHandler.canFormat(val)) continue;
                    t = valueHandler;
                    break;
                }
                dataStr = t != null ? t.toHTML(hdl.hdl, val) : (HDLProxy.looksLikeURI(dataStr = val.getDataAsString()) ? "<a href=\"" + StringUtils.encodeURLForAttr((String)dataStr) + "\">" + StringUtils.htmlEscapeWhitespace((String)dataStr) + "</a>" : StringUtils.htmlEscapeWhitespace((String)dataStr));
                page.append("<tr bgcolor=\"#" + (i % 2 == 0 ? "dddddd" : "ffffff") + "\">");
                page.append("<td align=\"left\" valign=\"top\"><b>");
                page.append(val.getIndex() + "</b>");
                page.append("</td><td align=\"left\" valign=\"top\"><b>");
                String typeAsStr = val.getTypeAsString();
                if (HDLProxy.looksLikeURI(typeAsStr)) {
                    page.append("<a href=\"" + StringUtils.encodeURLForAttr((String)typeAsStr) + "\">" + StringUtils.htmlEscapeWhitespaceNonBreakingSpaces((String)typeAsStr) + "</a>");
                } else if (typeAsStr.indexOf("/") >= 0) {
                    page.append("<a href=\"" + StringUtils.encodeURLForAttr((String)hdl.getURLForHandle(typeAsStr)) + "\">" + StringUtils.htmlEscapeWhitespaceNonBreakingSpaces((String)typeAsStr) + "</a>");
                } else {
                    String ucType = typeAsStr.toUpperCase();
                    if (ucType.startsWith("HS_") || ucType.equals("URL") || ucType.equals("DESC") || ucType.equals("EMAIL")) {
                        page.append("<a href=\"" + StringUtils.encodeURLForAttr((String)hdl.getURLForHandle("0.TYPE/" + typeAsStr)) + "\">" + StringUtils.htmlEscapeWhitespaceNonBreakingSpaces((String)typeAsStr) + "</a>");
                    } else {
                        page.append(StringUtils.htmlEscapeWhitespaceNonBreakingSpaces((String)typeAsStr));
                    }
                }
                page.append("</b></td><td valign=\"top\">");
                page.append("<span style='white-space:nowrap'>");
                page.append(StringUtils.htmlEscapeWhitespaceNonBreakingSpaces((String)val.getNicerTimestampAsString()));
                page.append("</span>");
                page.append("</td>\n");
                page.append("<td>" + dataStr + "</td>");
                page.append("</tr>\n");
            }
        } else {
            page.append("<tr><td align=CENTER><b>No values found.</b></td></tr>");
        }
        if (f != null) {
            HTMLFile hTMLFile = f;
            synchronized (hTMLFile) {
                f.reset();
                f.setValue("CONTEXT_PATH", HDLProxy.getContextPath(hdl));
                f.setValue("HANDLE", hdl.hdl);
                f.setValue("VALUES", page.toString());
                hdl.response.setContentType("text/html; charset=utf-8");
                f.output((OutputStream)hdl.response.getOutputStream());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnQueryPage(HDLServletRequest hdl) throws IOException {
        HTMLFile f = this.queryPages.get(hdl.req.getServerName().toLowerCase());
        if (f == null) {
            f = this.queryPages.get("default");
        }
        if (f == null) {
            this.returnErrorPage("Empty handle invalid.", hdl, null, null, 400);
            return;
        }
        hdl.response.setContentType("text/html; charset=utf-8");
        HTMLFile hTMLFile = f;
        synchronized (hTMLFile) {
            f.reset();
            f.setValue("CONTEXT_PATH", HDLProxy.getContextPath(hdl));
            f.output((OutputStream)hdl.response.getOutputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnHelpPage(HDLServletRequest hdl) throws IOException {
        String redirect = this.helpRedirect.get(hdl.req.getServerName().toLowerCase());
        if (redirect == null) {
            redirect = this.helpRedirect.get("default");
        }
        if (redirect != null) {
            hdl.sendHTTPRedirect(HDLServletRequest.ResponseType.OLD_MOVED_TEMPORARILY, redirect);
            return;
        }
        HTMLFile f = this.helpPages.get(hdl.req.getServerName().toLowerCase());
        if (f == null) {
            f = this.helpPages.get("default");
        }
        if (f == null) {
            this.returnErrorPage("help.html not found!", hdl, null, null, 500);
            return;
        }
        hdl.response.setContentType("text/html; charset=utf-8");
        HTMLFile hTMLFile = f;
        synchronized (hTMLFile) {
            f.reset();
            f.setValue("CONTEXT_PATH", HDLProxy.getContextPath(hdl));
            f.output((OutputStream)hdl.response.getOutputStream());
        }
    }

    public static final boolean looksLikeURI(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        if (sz == 0) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch != ' ' && ch != '\r' && ch != '\t' && ch != '\n') continue;
            return false;
        }
        char ch = str.charAt(0);
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
            for (int j = 1; j < sz; ++j) {
                ch = str.charAt(j);
                if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '+' || ch == '-' || ch == '.') continue;
                if (ch != ':') break;
                return true;
            }
        }
        return false;
    }

    public void logAccess(String accessType, int oc, int rc, HDLServletRequest req, HandleValue[] vals) {
        this.logAccess(accessType, oc, rc, req, vals, null);
    }

    public void logAccess(String accessType, int oc, int rc, HDLServletRequest req, HandleValue[] vals, String extraLogEntry) {
        if (this.logger == null) {
            return;
        }
        String addr = "";
        try {
            addr = req.getRemoteAddr();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String referer = req.getReferer();
        String userAgent = req.req.getHeader("user-agent");
        this.logAccess(accessType, oc, rc, req.hdl, addr, referer, userAgent, req.getResponseTime(), vals, extraLogEntry);
    }

    public void logAccess(String accessType, int oc, int rc, String hdl, String addr, String referer, String userAgent, long responseTime, HandleValue[] vals, String extraLogEntry) {
        if (this.logger == null) {
            return;
        }
        StringBuffer msg = new StringBuffer(50);
        msg.append(addr == null ? "" : addr);
        msg.append(' ');
        msg.append(accessType);
        msg.append(" \"");
        String dateStr = this.dateFormat.formatNow();
        msg.append(dateStr);
        msg.append("\" ");
        msg.append(oc);
        msg.append(' ');
        msg.append(rc);
        msg.append(' ');
        msg.append(responseTime);
        msg.append("ms ");
        msg.append(StringUtils.encodeURLPath((String)hdl));
        if (this.logHSAdmin) {
            msg.append(" \"");
            boolean firstAdmin = true;
            for (int i = 0; vals != null && i < vals.length; ++i) {
                if (!vals[i].hasType(Common.STD_TYPE_HSADMIN)) continue;
                AdminRecord adm = new AdminRecord();
                try {
                    Encoder.decodeAdminRecord(vals[i].getData(), 0, adm);
                }
                catch (Exception e) {
                    continue;
                }
                if (!firstAdmin) {
                    msg.append(',');
                }
                firstAdmin = false;
                msg.append(adm.adminIdIndex);
                msg.append(':');
                msg.append(StringUtils.encodeURLPath((String)Util.decodeString(adm.adminId)));
            }
            msg.append('\"');
        }
        if (this.logReferrer) {
            msg.append(" \"");
            if (referer != null) {
                msg.append(StringUtils.encodeURL((String)referer));
            }
            msg.append('\"');
        }
        String extraLogStr = null;
        if (extraLogEntry != null || this.logUserAgent && userAgent != null) {
            if (this.logUserAgent && userAgent != null) {
                extraLogEntry = extraLogEntry == null ? "" : extraLogEntry + " ";
                extraLogEntry = extraLogEntry + "user-agent:\"" + HDLProxy.quote(userAgent) + "\"";
            }
            extraLogStr = "\"" + dateStr + "\" " + extraLogEntry;
        }
        this.logger.logAccessAndExtra(msg.toString(), extraLogStr);
    }

    public void logError(int level, String logString) {
        if (this.handleServer == null) {
            if (this.logger != null) {
                this.logger.logError(level, logString);
            }
        } else {
            this.handleServer.logError(level, logString);
        }
    }

    static String quote(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        int sLen = s.length();
        for (int i = 0; i < sLen; ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (sb == null) {
                    sb = new StringBuilder(s.substring(0, i));
                }
                sb.append("\\\\");
                continue;
            }
            if (ch == '\"') {
                if (sb == null) {
                    sb = new StringBuilder(s.substring(0, i));
                }
                sb.append("\\\"");
                continue;
            }
            if (ch < ' ') {
                if (sb == null) {
                    sb = new StringBuilder(s.substring(0, i));
                }
                sb.append("\\u").append(String.format("%04X", ch));
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public String getHandleLinkPrefix(HttpServletRequest req) {
        String prefix = this.handleLinkPrefixMap.get(req.getServerName().toLowerCase());
        if (prefix == null) {
            prefix = this.handleLinkPrefixMap.get("default");
        }
        if (prefix == null) {
            int port = req.getServerPort();
            boolean usePort = true;
            if ("http".equalsIgnoreCase(req.getScheme()) && port == 80) {
                usePort = false;
            }
            if ("https".equalsIgnoreCase(req.getScheme()) && port == 443) {
                usePort = false;
            }
            prefix = req.getScheme() + "://" + req.getServerName() + (usePort ? ":" + port : "") + req.getContextPath() + "/";
        }
        return prefix;
    }

    public InetAddress getRemoteInetAddress(HttpServletRequest servletReq) {
        InetAddress cachedResult = (InetAddress)servletReq.getAttribute("cachedRemoteInetAddress");
        if (cachedResult != null) {
            return cachedResult;
        }
        try {
            InetAddress result = InetAddress.getByName(this.getRemoteAddr(servletReq));
            servletReq.setAttribute("cachedRemoteInetAddress", (Object)result);
            return result;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public String getRemoteAddr(HttpServletRequest servletReq) {
        String cachedResult = (String)servletReq.getAttribute("cachedRemoteAddr");
        if (cachedResult != null) {
            return cachedResult;
        }
        String result = this.getRemoteAddrNoCaching(servletReq);
        servletReq.setAttribute("cachedRemoteAddr", (Object)result);
        return result;
    }

    private String getRemoteAddrNoCaching(HttpServletRequest servletReq) {
        String remoteAddr = servletReq.getRemoteAddr();
        if (this.remoteAddressHeader == null) {
            return remoteAddr;
        }
        String headerValue = HDLProxy.getConcatenatedHeaderValue(servletReq, this.remoteAddressHeader);
        if (headerValue == null || headerValue.isEmpty()) {
            return remoteAddr;
        }
        List<String> proxies = HDLProxy.listValuesFromHeaderAndRemoteAddr(headerValue, remoteAddr);
        if (this.remoteAddressInternalProxies == null || this.remoteAddressInternalProxies.isEmpty()) {
            return proxies.get(0);
        }
        Collections.reverse(proxies);
        Iterator<String> iterator = proxies.iterator();
        while (iterator.hasNext()) {
            String potentialProxy;
            remoteAddr = potentialProxy = iterator.next();
            if (this.isProxy(potentialProxy)) continue;
            return remoteAddr;
        }
        return remoteAddr;
    }

    private boolean isProxy(String potentialProxy) {
        if (this.remoteAddressInternalProxies == null || this.remoteAddressInternalProxies.isEmpty()) {
            return true;
        }
        try {
            BigInteger target = CIDRUtils.asBigInteger(potentialProxy);
            for (CIDRUtils proxyRange : this.remoteAddressInternalProxies) {
                if (!proxyRange.isInRange(target)) continue;
                return true;
            }
            return false;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private static String getConcatenatedHeaderValue(HttpServletRequest servletReq, String header) {
        Enumeration e = servletReq.getHeaders(header);
        if (!e.hasMoreElements()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (e.hasMoreElements()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append((String)e.nextElement());
        }
        return sb.toString();
    }

    private static List<String> listValuesFromHeaderAndRemoteAddr(String headerValue, String remoteAddr) {
        String[] addrs = commaSeparatedValuesPattern.split(headerValue);
        ArrayList<String> res = new ArrayList<String>(addrs.length + 1);
        for (String addr : addrs) {
            if (addr.isEmpty()) continue;
            res.add(addr);
        }
        res.add(remoteAddr);
        return res;
    }

    static {
        DEFAULT_NAMESPACE_INFO = new NamespaceInfo();
        commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    }

    class TypeHandlerEntry {
        TypeHandler handler;
        int position;

        TypeHandlerEntry() {
        }
    }
}

