/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CorsAccessControlExposeHeadersFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doHttpFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void doHttpFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getHeader("Origin") == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            HeaderFixingResponseWrapper wrappedResponse = new HeaderFixingResponseWrapper(response);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
        }
    }

    private static class HeaderFixingResponseWrapper
    extends HttpServletResponseWrapper {
        private static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
        private final Set<String> exposedHeaders = new HashSet<String>();

        public HeaderFixingResponseWrapper(HttpServletResponse response) {
            super(response);
            this.exposedHeaders.add("Content-Length");
            this.fixResponseExposeHeaders();
        }

        private void fixResponseExposeHeaders() {
            Collection headers = this.getHeaders(ACCESS_CONTROL_EXPOSE_HEADERS);
            if (headers != null) {
                for (String header : headers) {
                    this.exposeAllHeaders(header);
                }
            }
            this.setExposeHeadersHeader();
        }

        private void setExposeHeadersHeader() {
            if (!this.exposedHeaders.isEmpty()) {
                super.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS, this.commify(this.exposedHeaders));
            }
        }

        private void exposeAllHeaders(String header) {
            if (header != null && !header.isEmpty()) {
                for (String field : header.split(",")) {
                    this.exposedHeaders.add(field);
                }
            }
        }

        public void setDateHeader(String name, long date) {
            this.exposeHeader(name);
            super.setDateHeader(name, date);
        }

        public void addDateHeader(String name, long date) {
            this.exposeHeader(name);
            super.addDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            if (name.equalsIgnoreCase("access-control-expose-headers")) {
                this.exposeAllHeaders(value);
                this.setExposeHeadersHeader();
            } else {
                this.exposeHeader(name);
                super.setHeader(name, value);
            }
        }

        public void addHeader(String name, String value) {
            if (name.equalsIgnoreCase("access-control-expose-headers")) {
                this.exposeAllHeaders(value);
                this.setExposeHeadersHeader();
            } else {
                this.exposeHeader(name);
                super.addHeader(name, value);
            }
        }

        public void setIntHeader(String name, int value) {
            this.exposeHeader(name);
            super.setIntHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            this.exposeHeader(name);
            super.addIntHeader(name, value);
        }

        private boolean isSimpleHeader(String name) {
            return name.equalsIgnoreCase("Cache-Control") || name.equalsIgnoreCase("Content-Language") || name.equalsIgnoreCase("Content-Type") || name.equalsIgnoreCase("Expires") || name.equalsIgnoreCase("Last-Modified") || name.equalsIgnoreCase("Pragma");
        }

        private void exposeHeader(String name) {
            if (this.exposedHeaders != null && !name.toLowerCase().startsWith("access-control-") && !this.isSimpleHeader(name)) {
                this.exposedHeaders.add(name);
                super.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS, this.commify(this.exposedHeaders));
            }
        }

        private String commify(Collection<String> ss) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String s : ss) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(s);
            }
            return sb.toString();
        }
    }
}

