/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class BlacklistFilter
implements Filter {
    String email;
    ScheduledExecutorService execServ;
    File blacklistFile;
    long lastLastModified;
    volatile Set<String> blacklist;

    public void init(FilterConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        String blacklistPathString = context.getRealPath("/WEB-INF/blacklist.txt");
        if (blacklistPathString == null) {
            System.err.println("Unable to initialize blacklist refresh thread.");
            return;
        }
        this.blacklistFile = new File(blacklistPathString);
        this.email = config.getInitParameter("email");
        this.refreshBlacklist();
        this.execServ = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "BlacklistFilter");
            t.setDaemon(true);
            return t;
        });
        this.execServ.scheduleAtFixedRate(() -> this.refreshBlacklist(), 1L, 1L, TimeUnit.MINUTES);
    }

    public void destroy() {
        if (this.execServ != null) {
            this.execServ.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBlacklist() {
        long lastModified = this.blacklistFile.lastModified();
        if (lastModified == 0L && this.lastLastModified > 0L) {
            this.blacklist = null;
            this.lastLastModified = 0L;
            return;
        }
        if (lastModified > this.lastLastModified) {
            HashSet<String> newBlacklist = new HashSet<String>();
            FileInputStream fis = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                String line;
                fis = new FileInputStream(this.blacklistFile);
                isr = new InputStreamReader((InputStream)fis, "UTF-8");
                br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    newBlacklist.add(line);
                }
            }
            catch (IOException e) {
                System.err.println("Error refreshing blacklist");
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (Exception exception) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.blacklist = newBlacklist;
            this.lastLastModified = lastModified;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isBlacklisted(request)) {
            response.setStatus(429);
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.println("Your request has been declined due to a large number of requests.");
            writer.print("Please contact ");
            writer.print(this.email);
            writer.println(" for assistance.");
        } else {
            chain.doFilter(request, (ServletResponse)response);
        }
    }

    private boolean isBlacklisted(ServletRequest request) {
        if (this.blacklist == null) {
            return false;
        }
        String ip = request.getRemoteAddr();
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        return this.blacklist.contains(ip);
    }
}

