/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Vector;
import net.handle.apps.db_tool.InterfacePanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.GenericDialog;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.Util;

public class ServerInfoPanel
extends Panel
implements ActionListener {
    private final TextField serverIdField;
    private final TextField addressField;
    private final TextArea publicKeyField;
    private final Vector<Interface> interfaces;
    private final List interfaceList;
    private final Button publicKeyButton;
    private final Button addInterfaceButton;
    private final Button remInterfaceButton;
    private final Button editInterfaceButton;
    private final Button upInterfaceButton;
    private final Button downInterfaceButton;

    public ServerInfoPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.addressField = new TextField("", 15);
        this.serverIdField = new TextField("1", 5);
        this.publicKeyField = new TextArea("", 4, 25);
        this.interfaces = new Vector();
        this.interfaceList = new List(5);
        this.addInterfaceButton = new Button("Add");
        this.remInterfaceButton = new Button("Remove");
        this.editInterfaceButton = new Button("Modify");
        this.upInterfaceButton = new Button("^");
        this.downInterfaceButton = new Button("v");
        this.publicKeyButton = new Button("Public Key: ");
        int y = 0;
        this.add((Component)new Label("IP Address: ", 2), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.addressField, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, true, true));
        this.add((Component)new Label("Server ID: ", 2), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.serverIdField, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, true, true));
        this.add((Component)this.publicKeyButton, AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, true, false));
        this.add((Component)this.publicKeyField, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, true, true));
        Panel interfacePanel = new Panel(gridbag);
        interfacePanel.add((Component)this.interfaceList, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 10, true, true));
        interfacePanel.add((Component)this.addInterfaceButton, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 2, 1, true, true));
        interfacePanel.add((Component)this.remInterfaceButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 2, 1, true, true));
        interfacePanel.add((Component)this.editInterfaceButton, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 2, 1, true, true));
        interfacePanel.add((Component)this.upInterfaceButton, AwtUtil.getConstraints(1, 3, 0.1, 0.0, 1, 1, true, true));
        interfacePanel.add((Component)this.downInterfaceButton, AwtUtil.getConstraints(2, 3, 0.1, 0.0, 1, 1, true, true));
        this.add((Component)new Label("Interfaces: ", 2), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)interfacePanel, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, true, true));
        this.interfaceList.addActionListener(this);
        this.addInterfaceButton.addActionListener(this);
        this.remInterfaceButton.addActionListener(this);
        this.editInterfaceButton.addActionListener(this);
        this.upInterfaceButton.addActionListener(this);
        this.downInterfaceButton.addActionListener(this);
        this.publicKeyButton.addActionListener(this);
    }

    public void getServerInfo(ServerInfo server) {
        try {
            server.serverId = Integer.parseInt(this.serverIdField.getText().trim());
        }
        catch (Exception e) {
            this.getToolkit().beep();
        }
        try {
            InetAddress addr = InetAddress.getByName(this.addressField.getText().trim());
            byte[] addr1 = addr.getAddress();
            byte[] addr2 = new byte[16];
            for (int i = 0; i < 16; ++i) {
                addr2[i] = 0;
            }
            System.arraycopy(addr1, 0, addr2, addr2.length - addr1.length, addr1.length);
            server.ipAddress = addr2;
        }
        catch (Exception e) {
            this.getToolkit().beep();
        }
        try {
            server.publicKey = Util.encodeHexString(this.publicKeyField.getText());
        }
        catch (Exception e) {
            this.getToolkit().beep();
        }
        server.interfaces = new Interface[this.interfaces.size()];
        for (int i = 0; i < server.interfaces.length; ++i) {
            server.interfaces[i] = this.interfaces.elementAt(i);
        }
    }

    public void setServerInfo(ServerInfo server) {
        this.serverIdField.setText(String.valueOf(server.serverId));
        this.publicKeyField.setText(Util.decodeHexString(server.publicKey, true));
        this.addressField.setText(server.getAddressString());
        this.interfaces.removeAllElements();
        if (server.interfaces != null) {
            for (int i = 0; i < server.interfaces.length; ++i) {
                this.interfaces.addElement(server.interfaces[i]);
            }
        }
        this.rebuildInterfaceList();
    }

    private void rebuildInterfaceList() {
        this.interfaceList.removeAll();
        for (int i = 0; i < this.interfaces.size(); ++i) {
            this.interfaceList.add(String.valueOf(this.interfaces.elementAt(i)));
        }
    }

    private void evtAddInterface() {
        InterfacePanel svrPanel = new InterfacePanel();
        if (2 == GenericDialog.showDialog("Add Interface", svrPanel, 3, this)) {
            return;
        }
        Interface intrfc = new Interface();
        svrPanel.getInterface(intrfc);
        this.interfaces.addElement(intrfc);
        this.rebuildInterfaceList();
    }

    private void evtRemInterface() {
        int idx = this.interfaceList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        this.interfaces.removeElementAt(idx);
        this.rebuildInterfaceList();
    }

    private void evtEditInterface() {
        int idx = this.interfaceList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        Interface intrfc = this.interfaces.elementAt(idx);
        InterfacePanel svrPanel = new InterfacePanel();
        svrPanel.setInterface(intrfc);
        if (2 == GenericDialog.showDialog("Edit Interface", svrPanel, 3, this)) {
            return;
        }
        svrPanel.getInterface(intrfc);
        this.rebuildInterfaceList();
    }

    private void evtUpInterface() {
        int idx = this.interfaceList.getSelectedIndex();
        if (idx <= 0) {
            return;
        }
        Interface intrfc = this.interfaces.elementAt(idx);
        this.interfaces.removeElementAt(idx);
        this.interfaces.insertElementAt(intrfc, idx - 1);
        this.rebuildInterfaceList();
        this.interfaceList.select(idx - 1);
    }

    private void evtDownInterface() {
        int idx = this.interfaceList.getSelectedIndex();
        if (idx < 0 || idx == this.interfaces.size() - 1) {
            return;
        }
        Interface intrfc = this.interfaces.elementAt(idx);
        this.interfaces.removeElementAt(idx);
        this.interfaces.insertElementAt(intrfc, idx + 1);
        this.rebuildInterfaceList();
        this.interfaceList.select(idx + 1);
    }

    private void evtPublicKey() {
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Select Public Key File", 0);
        fwin.setFile("pubkey.bin");
        fwin.setVisible(true);
        String dir = fwin.getDirectory();
        String file = fwin.getFile();
        if (dir == null || file == null || file.trim().length() <= 0) {
            return;
        }
        try {
            File keyFile = new File(dir, file);
            byte[] rawKey = new byte[(int)keyFile.length()];
            FileInputStream in = new FileInputStream(keyFile);
            int r = 0;
            for (int n = 0; n < rawKey.length && (r = ((InputStream)in).read(rawKey, n, rawKey.length - n)) > 0; n += r) {
            }
            ((InputStream)in).close();
            this.publicKeyField.setText(Util.decodeHexString(rawKey, true));
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            GenericDialog.askQuestion("Error", "Error unable to load key: " + e, 0, this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.addInterfaceButton) {
            this.evtAddInterface();
        } else if (src == this.remInterfaceButton) {
            this.evtRemInterface();
        } else if (src == this.editInterfaceButton) {
            this.evtEditInterface();
        } else if (src == this.upInterfaceButton) {
            this.evtUpInterface();
        } else if (src == this.downInterfaceButton) {
            this.evtDownInterface();
        } else if (src == this.publicKeyButton) {
            this.evtPublicKey();
        }
    }
}

