/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.server.HandleStorageFactory;

public class DBResolve {
    private final HandleStorage storage;
    private boolean caseSensitive;

    public DBResolve(HandleStorage storage) {
        this.storage = storage;
    }

    public HandleValue[] resolve(String handle) throws HandleException {
        byte[][] rawValues = this.storage.getRawHandleValues(this.caseSensitive ? Util.encodeString(handle) : Util.upperCase(Util.encodeString(handle)), null, null);
        if (rawValues == null) {
            return null;
        }
        HandleValue[] values = new HandleValue[rawValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new HandleValue();
            Encoder.decodeHandleValue(rawValues[i], 0, values[i]);
        }
        return values;
    }

    public static void main(String[] argv) throws Exception {
        String handle;
        if (argv == null || argv.length < 1) {
            System.err.println("usage: java net.handle.apps.db_tool.DBResolve <server-directory>");
            System.err.println("followed by handles to resolve one per line");
            return;
        }
        File serverDir = new File(argv[0]);
        StreamTable serverInfo = new StreamTable();
        serverInfo.readFromFile(new File(serverDir, "config.dct"));
        serverInfo = (StreamTable)serverInfo.get("server_config");
        HandleStorage storage = HandleStorageFactory.getStorage(serverDir, serverInfo, true, true);
        DBResolve dbResolve = new DBResolve(storage);
        dbResolve.caseSensitive = serverInfo.getBoolean("case_sensitive");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        while ((handle = reader.readLine()) != null) {
            System.out.println(handle);
            try {
                HandleValue[] values = dbResolve.resolve(handle);
                if (values == null) {
                    System.out.println("null");
                    continue;
                }
                for (HandleValue value : values) {
                    System.out.println(value.toDetailedString());
                }
            }
            catch (HandleException e) {
                System.out.println(e);
            }
            System.out.println();
        }
    }
}

