/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.io.File;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.server.HandleStorageFactory;

public class DBList {
    private final HandleStorage storage;
    private boolean verbose = false;

    public DBList(HandleStorage storage) {
        this.storage = storage;
    }

    public void listHandles() {
        try {
            this.storage.scanHandles(new ScanCallback(){

                @Override
                public void scanHandle(byte[] handle) {
                    System.out.println(Util.decodeString(handle));
                    if (DBList.this.verbose) {
                        try {
                            byte[][] chunks = DBList.this.storage.getRawHandleValues(handle, null, null);
                            HandleValue[] values = Encoder.decodeHandleValues(chunks);
                            GsonUtility.getPrettyGson().toJson((Object)values, (Appendable)System.out);
                            System.out.println();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                        System.out.println();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void listPrefixes() {
        try {
            this.storage.scanNAs(new ScanCallback(){

                @Override
                public void scanHandle(byte[] handle) {
                    System.out.println(Util.decodeString(handle));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv == null || argv.length < 1) {
            System.err.println("usage: java net.handle.apps.db_tool.DBList <server-directory> [-p] [-v]");
            return;
        }
        File serverDir = new File(argv[0]);
        StreamTable serverInfo = new StreamTable();
        serverInfo.readFromFile(new File(serverDir, "config.dct"));
        serverInfo = (StreamTable)serverInfo.get("server_config");
        HandleStorage storage = HandleStorageFactory.getStorage(serverDir, serverInfo, true, true);
        DBList dbList = new DBList(storage);
        for (String arg : argv) {
            if (arg.equals("-p")) {
                dbList.listPrefixes();
                System.exit(0);
            }
            if (!arg.equals("-v")) continue;
            dbList.verbose = true;
        }
        dbList.listHandles();
    }
}

