/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.util.ArrayList;
import java.util.List;
import net.handle.apps.batch.HandleRecordFilter;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ListHandlesUtil {
    private final SiteInfo site;
    private final AuthenticationInfo authInfo;
    private final HandleResolver resolver;

    public ListHandlesUtil(SiteInfo site, AuthenticationInfo authInfo, HandleResolver resolver) {
        this.site = site;
        this.authInfo = authInfo;
        this.resolver = resolver;
    }

    public List<String> getMatchingHandles(HandleRecordFilter filter, String prefix) throws HandleException {
        ArrayList<String> result = new ArrayList<String>();
        byte[] prefixBytes = Util.encodeString(prefix);
        ListHandlesRequest request = new ListHandlesRequest(prefixBytes, this.authInfo);
        ListHandlesAccumulator handlesAccumulator = new ListHandlesAccumulator();
        this.resolver.sendRequestToSite((AbstractRequest)request, this.site, handlesAccumulator);
        List<String> allHandles = handlesAccumulator.handlesList;
        int progressCount = 0;
        for (String handle : allHandles) {
            HandleValue[] values;
            if (++progressCount % 10 == 0) {
                System.out.println("progressCount: " + progressCount);
            }
            if (!filter.accept(values = this.resolver.resolveHandle(handle))) continue;
            result.add(handle);
            System.out.println(".");
        }
        return result;
    }

    public List<String> getAllHandles(String prefix) throws HandleException {
        byte[] prefixBytes = Util.encodeString(prefix);
        ListHandlesRequest request = new ListHandlesRequest(prefixBytes, this.authInfo);
        ListHandlesAccumulator handlesAccumulator = new ListHandlesAccumulator();
        this.resolver.sendRequestToSite((AbstractRequest)request, this.site, handlesAccumulator);
        List<String> allHandles = handlesAccumulator.handlesList;
        return allHandles;
    }

    public static class ListHandlesAccumulator
    implements ResponseMessageCallback {
        public List<String> handlesList = new ArrayList<String>();

        @Override
        public void handleResponse(AbstractResponse response) throws HandleException {
            if (response.responseCode == 1) {
                byte[][] handles;
                for (byte[] handleBytes : handles = ((ListHandlesResponse)response).handles) {
                    String handle = Util.decodeString(handleBytes);
                    this.handlesList.add(handle);
                }
            }
        }
    }
}

