/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.VersionMismatchException;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;

public class DbPreUpgrade_4_1 {
    private File envHome;
    private Environment env;
    private static final String usageString = "usage: " + CmdUtil.getJavaCommand(DbPreUpgrade_4_1.class) + "\n" + "  -h <dir> # environment home directory\n";

    private DbPreUpgrade_4_1() {
    }

    public DbPreUpgrade_4_1(File envHome) {
        this.envHome = envHome;
    }

    public static void main(String[] args) throws Exception {
        DbPreUpgrade_4_1 upgrader = new DbPreUpgrade_4_1();
        upgrader.parseArgs(args);
        try {
            upgrader.preUpgrade();
            System.out.println("Pre-upgrade succeeded");
            System.exit(0);
        }
        catch (VersionMismatchException e) {
            System.out.println("Upgrade already complete");
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("Pre-upgrade failed: " + e);
            System.exit(1);
        }
    }

    private void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] args) {
        int argc = 0;
        int nArgs = args.length;
        if (nArgs != 2) {
            this.printUsage("Invalid argument");
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = args[argc++].trim()).equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(args[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            this.printUsage("Invalid argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    public void preUpgrade() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        DbPreUpgrade_4_1.configureForPreUpgrade(envConfig);
        Environment env = new Environment(this.envHome, envConfig);
        DbPreUpgrade_4_1.performPreUpgrade(env);
        env.close();
    }

    public static void configureForPreUpgrade(EnvironmentConfig envConfig) {
        envConfig.setAllowCreate(true);
        envConfig.setConfigParam("je.env.runCleaner", "false");
        envConfig.setConfigParam("je.env.runCheckpointer", "false");
        envConfig.setConfigParam("je.env.runEvictor", "false");
        envConfig.setConfigParam("je.env.runINCompressor", "false");
    }

    public static void performPreUpgrade(Environment env) {
        DbInternal.getEnvironmentImpl(env).getEvictor().shutdown();
        env.sync();
        env.sync();
    }
}

