/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.VLSNRecoveryProxy;
import com.sleepycat.je.rep.DatabasePreemptedException;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.LockPreemptedException;
import com.sleepycat.je.rep.LogOverwriteException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepConfigManager;
import com.sleepycat.je.rep.impl.RepEnvConfigObserver;
import com.sleepycat.je.rep.impl.RepImplStatDefinition;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.NodeState;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.stream.FeederTxns;
import com.sleepycat.je.rep.txn.MasterThreadLocker;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.rep.txn.ReadonlyTxn;
import com.sleepycat.je.rep.txn.ReplayTxn;
import com.sleepycat.je.rep.txn.ReplicaThreadLocker;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRecoveryTracker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.utilint.BooleanStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StringStat;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Formatter;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepImpl
extends EnvironmentImpl
implements RepEnvConfigObserver {
    private VLSNIndex vlsnIndex;
    private final FeederTxns feederTxns;
    private volatile RepNode repNode;
    private Replay replay;
    private NameIdPair nameIdPair;
    private final NodeState nodeState;
    private static int clockSkewMs = 0;
    private DatabaseImpl groupDbImpl = null;
    private boolean backupProhibited = false;
    private boolean allowConvert = false;
    private final Set<DbBackup> backups = new HashSet<DbBackup>();
    private final List<RepEnvConfigObserver> repConfigObservers;
    private final ReentrantLock groupDbLock = new ReentrantLock();
    private final int replicaAckTimeout;
    private final int insufficientReplicasTimeout;
    private final int replayTxnTimeout;
    private final ReplicaConsistencyPolicy defaultConsistencyPolicy;
    private final StatGroup nodeStats;
    private final BooleanStat hardRecoveryStat;
    private final StringStat hardRecoveryInfoStat;

    public RepImpl(File envHome, EnvironmentConfig envConfig, EnvironmentImpl sharedCacheEnv, RepConfigProxy repConfigProxy) throws EnvironmentNotFoundException, EnvironmentLockedException {
        super(envHome, envConfig, sharedCacheEnv, repConfigProxy);
        this.allowConvert = RepInternal.getAllowConvert((ReplicationConfig)repConfigProxy);
        this.feederTxns = new FeederTxns(this);
        this.replay = new Replay(this, this.nameIdPair);
        this.nodeState = new NodeState(this.nameIdPair, this);
        this.repConfigObservers = new ArrayList<RepEnvConfigObserver>();
        this.replicaAckTimeout = this.configManager.getDuration(RepParams.REPLICA_ACK_TIMEOUT);
        this.insufficientReplicasTimeout = this.configManager.getDuration(RepParams.INSUFFICIENT_REPLICAS_TIMEOUT);
        this.replayTxnTimeout = this.configManager.getDuration(RepParams.REPLAY_TXN_LOCK_TIMEOUT);
        this.defaultConsistencyPolicy = RepUtils.getReplicaConsistencyPolicy(this.configManager.get(RepParams.CONSISTENCY_POLICY));
        this.addRepConfigObserver(this);
        this.nodeStats = new StatGroup("ReplicatedEnvironment", "General information about a replication node");
        this.hardRecoveryStat = new BooleanStat(this.nodeStats, RepImplStatDefinition.HARD_RECOVERY);
        this.hardRecoveryInfoStat = new StringStat(this.nodeStats, RepImplStatDefinition.HARD_RECOVERY_INFO, "This node did not incur a hard recovery.");
    }

    @Override
    protected Formatter initFormatter() {
        this.nameIdPair = new NameIdPair(this.configManager.get(RepParams.NODE_NAME));
        return new ReplicationFormatter(this.nameIdPair);
    }

    @Override
    public String getMonitorClassName() {
        return "com.sleepycat.je.rep.jmx.RepJEMonitor";
    }

    @Override
    public String getDiagnosticsClassName() {
        return "com.sleepycat.je.rep.jmx.RepJEDiagnostics";
    }

    @Override
    protected DbConfigManager initConfigManager(EnvironmentConfig envConfig, RepConfigProxy repConfigProxy) {
        return new RepConfigManager(envConfig, repConfigProxy);
    }

    @Override
    public boolean getAllowConvert() {
        return this.allowConvert;
    }

    @Override
    protected DbConfigManager resetConfigManager(EnvironmentConfig newConfig) {
        RepConfigManager repConfigManager = (RepConfigManager)this.configManager;
        ReplicationConfig repConfig = repConfigManager.makeReplicationConfig();
        return new RepConfigManager(newConfig, repConfig);
    }

    public ReplicationConfig cloneRepConfig() {
        RepConfigManager repConfigManager = (RepConfigManager)this.configManager;
        return repConfigManager.makeReplicationConfig();
    }

    public ReplicatedEnvironment makeEnvironment() {
        return new ReplicatedEnvironment(this.getEnvironmentHome(), this.cloneRepConfig(), this.cloneConfig());
    }

    public ReplicationMutableConfig cloneRepMutableConfig() {
        RepConfigManager repConfigManager = (RepConfigManager)this.configManager;
        return repConfigManager.makeReplicationConfig();
    }

    public void setRepMutableConfig(ReplicationMutableConfig config) throws DatabaseException {
        RepConfigManager repConfigManager = (RepConfigManager)this.configManager;
        ReplicationConfig newConfig = repConfigManager.makeReplicationConfig();
        config.copyMutablePropsTo(newConfig);
        repConfigManager = new RepConfigManager(this.configManager.getEnvironmentConfig(), newConfig);
        for (int i = this.repConfigObservers.size() - 1; i >= 0; --i) {
            RepEnvConfigObserver o = this.repConfigObservers.get(i);
            o.repEnvConfigUpdate(repConfigManager, newConfig);
        }
    }

    @Override
    public void repEnvConfigUpdate(RepConfigManager configMgr, ReplicationMutableConfig newConfig) throws DatabaseException {
        if (!newConfig.getDesignatedPrimary()) {
            this.repNode.passivatePrimary();
        }
        this.repNode.setElectableGroupSizeOverride(newConfig.getElectableGroupSizeOverride());
        this.repNode.configLogFlusher(configMgr);
    }

    public synchronized void addRepConfigObserver(RepEnvConfigObserver o) {
        this.repConfigObservers.add(o);
    }

    @Override
    public void preRecoveryCheckpointInit(RecoveryInfo recoveryInfo) {
        int stride = this.configManager.getInt(RepParams.VLSN_STRIDE);
        int maxMappings = this.configManager.getInt(RepParams.VLSN_MAX_MAP);
        int maxDist = this.configManager.getInt(RepParams.VLSN_MAX_DIST);
        NameIdPair useNameIdPair = new NameIdPair(this.configManager.get(RepParams.NODE_NAME));
        this.vlsnIndex = new VLSNIndex(this, "_jeVlsnMapDb", useNameIdPair, stride, maxMappings, maxDist, recoveryInfo);
        this.replay.preRecoveryCheckpointInit(recoveryInfo);
    }

    public ReplicatedEnvironment.State getState() {
        return this.nodeState.getRepEnvState();
    }

    public StateChangeEvent getStateChangeEvent() {
        return this.nodeState.getStateChangeEvent();
    }

    public synchronized ReplicatedEnvironment.State joinGroup(ReplicaConsistencyPolicy consistency, QuorumPolicy initialElectionPolicy) throws ReplicaConsistencyException, DatabaseException {
        try {
            if (this.repNode == null) {
                this.repNode = new RepNode(this, this.replay, this.nodeState);
            }
            return this.repNode.joinGroup(consistency, initialElectionPolicy);
        }
        catch (IOException ioe) {
            throw EnvironmentFailureException.unexpectedException(this, "Problem attempting to join on " + this.getSocket(), ioe);
        }
    }

    @Override
    protected synchronized void setupClose(PrintWriter errors) throws DatabaseException {
        if (this.groupDbImpl != null) {
            this.getDbTree().releaseDb(this.groupDbImpl);
            this.groupDbImpl = null;
            LoggerUtils.fine(this.envLogger, this, "Group member database shutdown");
        }
        try {
            if (this.repNode != null) {
                this.repNode.shutdown();
                this.repNode = null;
            }
        }
        catch (InterruptedException e) {
            errors.append("\nException shutting down node " + this.nameIdPair);
            e.printStackTrace(errors);
            errors.println();
        }
    }

    @Override
    protected synchronized void postCheckpointClose(boolean checkpointed) throws DatabaseException {
        if (this.replay != null) {
            this.replay.close();
            this.replay = null;
        }
        if (this.vlsnIndex != null) {
            this.vlsnIndex.close(checkpointed);
            this.vlsnIndex = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postRecoveryConversion() throws DatabaseException {
        if (this.needConvert) {
            DatabaseImpl nameDb = null;
            try {
                nameDb = this.dbMapTree.getDb(DbTree.NAME_DB_ID);
                if (!nameDb.isReplicated()) {
                    nameDb.setIsReplicatedBit();
                    nameDb.setDirtyUtilization();
                }
                Object var3_2 = null;
                if (nameDb != null) {
                    this.dbMapTree.releaseDb(nameDb);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (nameDb != null) {
                    this.dbMapTree.releaseDb(nameDb);
                }
                throw throwable;
            }
            Map<DatabaseId, String> idNameMap = this.dbMapTree.getDbNamesAndIds();
            for (DatabaseId id : idNameMap.keySet()) {
                Object var7_8;
                DatabaseImpl db = null;
                try {
                    db = this.dbMapTree.getDb(id);
                    if (db != null && !DbTree.isReservedDbName(idNameMap.get(id))) {
                        db.setIsReplicatedBit();
                        db.setDirtyUtilization();
                    }
                    var7_8 = null;
                    if (db == null) continue;
                    this.dbMapTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    if (db != null) {
                        this.dbMapTree.releaseDb(db);
                    }
                    throw throwable;
                }
            }
            CheckpointConfig ckptConfig = new CheckpointConfig();
            ckptConfig.setForce(true);
            this.invokeCheckpoint(ckptConfig, true, "Environment conversion");
        }
    }

    @Override
    public synchronized void doCloseAfterInvalid() {
        try {
            if (this.repNode != null) {
                this.repNode.shutdown();
                this.repNode = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.doCloseAfterInvalid();
    }

    @Override
    public void abnormalClose() throws DatabaseException {
        this.shutdownDaemons();
        try {
            if (this.repNode != null) {
                this.repNode.getMonitorEventManager().disableLeaveGroupEvent();
                this.repNode.shutdown();
                this.repNode = null;
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            if (this.vlsnIndex != null) {
                this.vlsnIndex.abnormalClose();
                this.vlsnIndex = null;
            }
        }
        catch (DatabaseException ignore) {
            // empty catch block
        }
        try {
            super.abnormalClose();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    @Override
    public void registerVLSN(LogItem logItem) {
        LogEntryHeader header = logItem.getHeader();
        VLSN vlsn = header.getVLSN();
        if (LogEntryType.LOG_TXN_COMMIT.getTypeNum() == header.getType()) {
            this.repNode.currentCommitVLSN(vlsn);
        }
        if (LogEntryType.isSyncPoint(header.getType()) || VLSN.FIRST_VLSN.equals(vlsn)) {
            this.repNode.trackSyncableVLSN(vlsn, logItem.getNewLsn());
        }
        this.vlsnIndex.put(logItem);
    }

    @Override
    public VLSN bumpVLSN() {
        return this.vlsnIndex.bump();
    }

    @Override
    public void decrementVLSN() {
        this.vlsnIndex.decrement();
    }

    @Override
    public void preCheckpointEndFlush() throws DatabaseException {
        if (this.vlsnIndex != null) {
            this.vlsnIndex.flushToDatabase();
        }
    }

    @Override
    public boolean isMaster() {
        RepNode useNode = this.repNode;
        if (useNode == null) {
            return false;
        }
        return useNode.isMaster();
    }

    public void setChangeListener(StateChangeListener listener) {
        StateChangeListener prevListener = this.nodeState.getChangeListener();
        this.nodeState.setChangeListener(listener);
        StateChangeEvent stateChangeEvent = this.nodeState.getStateChangeEvent();
        try {
            listener.stateChange(stateChangeEvent);
        }
        catch (Exception e) {
            this.nodeState.setChangeListener(prevListener);
            LoggerUtils.severe(this.envLogger, this, "State Change listener exception: " + e.getMessage());
            throw new EnvironmentFailureException((EnvironmentImpl)this, EnvironmentFailureReason.LISTENER_EXCEPTION, (Throwable)e);
        }
    }

    public StateChangeListener getChangeListener() {
        return this.nodeState.getChangeListener();
    }

    public VLSNIndex getVLSNIndex() {
        return this.vlsnIndex;
    }

    public FeederTxns getFeederTxns() {
        return this.feederTxns;
    }

    public ReplicatedEnvironmentStats getStats(StatsConfig config) {
        return this.repNode.getStats(config);
    }

    public Replay getReplay() {
        return this.replay;
    }

    private void checkIfMaster(Locker locker) throws UnknownMasterException, ReplicaWriteException {
        StateChangeEvent event = this.nodeState.getStateChangeEvent();
        switch (this.nodeState.getRepEnvState()) {
            case MASTER: {
                break;
            }
            case REPLICA: {
                throw new ReplicaWriteException(locker, event);
            }
            case UNKNOWN: {
                throw new UnknownMasterException(locker, event);
            }
            case DETACHED: {
                throw new UnknownMasterException(locker, event);
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("Unexpected state: " + (Object)((Object)this.nodeState.getRepEnvState()));
            }
        }
    }

    public RepNode getRepNode() {
        return this.repNode;
    }

    @Override
    public ThreadLocker createRepThreadLocker() {
        return this.isMaster() ? new MasterThreadLocker(this) : new ReplicaThreadLocker(this);
    }

    @Override
    public Txn createRepUserTxn(TransactionConfig config) throws DatabaseException {
        return this.isMaster() ? MasterTxn.create(this, config, this.nameIdPair) : new ReadonlyTxn(this, config);
    }

    public void txnBeginHook(MasterTxn txn) throws InterruptedException, DatabaseException {
        this.checkIfInvalid();
        Durability.ReplicaAckPolicy ackPolicy = txn.getDefaultDurability().getReplicaAck();
        int requiredNodeCount = this.repNode.minAckNodes(txn.getDefaultDurability());
        this.repNode.feederManager().ensureReplicasForCommit(txn, ackPolicy, requiredNodeCount, this.insufficientReplicasTimeout);
    }

    public void preLogCommitHook(MasterTxn txn) throws InsufficientReplicasException, RestartRequiredException, UnknownMasterException, ReplicaWriteException, EnvironmentFailureException {
        this.checkIfInvalid();
        this.checkIfMaster(txn);
        int activeReplicaCount = this.repNode.feederManager().activeReplicaCount();
        Durability.ReplicaAckPolicy ackPolicy = txn.getCommitDurability().getReplicaAck();
        int requiredAckCount = txn.getRequiredAckCount();
        if (this.envLogger.isLoggable(Level.FINE)) {
            LoggerUtils.fine(this.envLogger, this, "Txn " + txn.getId() + " requires: " + requiredAckCount + " active: " + activeReplicaCount + " replica acks. Commit Policy: " + (Object)((Object)ackPolicy));
        }
        if (requiredAckCount > activeReplicaCount) {
            if (this.repNode.tryActivatePrimary()) {
                txn.resetRequiredAckCount();
            } else {
                InsufficientReplicasException ire = new InsufficientReplicasException((Locker)txn, ackPolicy, requiredAckCount, this.repNode.feederManager().activeReplicas());
                LoggerUtils.info(this.envLogger, this, ire.getMessage());
                throw ire;
            }
        }
        this.feederTxns.setupForAcks(txn);
    }

    public void postLogCommitHook(MasterTxn txn) throws InsufficientAcksException, InterruptedException, EnvironmentFailureException {
        this.checkIfInvalid();
        try {
            this.feederTxns.awaitReplicaAcks(txn, this.replicaAckTimeout);
        }
        catch (InsufficientAcksException e) {
            LoggerUtils.info(this.envLogger, this, e.getMessage());
            throw e;
        }
    }

    public void postLogAbortHook(MasterTxn txn) {
        LoggerUtils.info(this.envLogger, this, "post log abort hook for txn: " + txn.getId());
        this.feederTxns.clearTransactionAcks(txn);
    }

    @Override
    public Txn createReplayTxn(long txnId) throws DatabaseException {
        return new ReplayTxn((EnvironmentImpl)this, TransactionConfig.DEFAULT, txnId, this.envLogger);
    }

    @Override
    public VLSNRecoveryProxy getVLSNProxy() {
        int stride = this.configManager.getInt(RepParams.VLSN_STRIDE);
        int maxMappings = this.configManager.getInt(RepParams.VLSN_MAX_MAP);
        int maxDist = this.configManager.getInt(RepParams.VLSN_MAX_DIST);
        return new VLSNRecoveryTracker(this, stride, maxMappings, maxDist);
    }

    public UUID getUUID() {
        return this.repNode.getUUID();
    }

    public static void setSkewMs(int skewMs) {
        clockSkewMs = skewMs;
    }

    public static int getClockSkewMs() {
        return clockSkewMs;
    }

    @Override
    public void vlsnHeadTruncate(VLSN lastVLSN, long deleteFileNum) {
        this.vlsnIndex.truncateFromHead(lastVLSN, deleteFileNum);
    }

    public int getNodeId() {
        return this.nameIdPair.getId();
    }

    public NameIdPair getNameIdPair() {
        return this.nameIdPair;
    }

    @Override
    public long getReplayTxnTimeout() {
        return this.replayTxnTimeout;
    }

    public ReplicaConsistencyPolicy getDefaultConsistencyPolicy() {
        return this.defaultConsistencyPolicy;
    }

    @Override
    public String getName() {
        return this.nameIdPair + ":" + super.getName();
    }

    @Override
    public boolean isReplicated() {
        return true;
    }

    @Override
    public void checkRulesForExistingEnv(boolean dbTreeReplicatedBit) throws UnsupportedOperationException {
        if (!dbTreeReplicatedBit) {
            throw new UnsupportedOperationException("This environment must be converted for replication. using com.sleepycat.je.rep.util.DbEnableReplication.");
        }
    }

    public String getHostName() {
        String hostAndPort = this.configManager.get(RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        return colonToken >= 0 ? hostAndPort.substring(0, colonToken) : hostAndPort;
    }

    public int getPort() {
        String hostAndPort = this.configManager.get(RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        return colonToken >= 0 ? Integer.parseInt(hostAndPort.substring(colonToken + 1)) : this.configManager.getInt(RepParams.DEFAULT_PORT);
    }

    public InetSocketAddress getSocket() {
        return new InetSocketAddress(this.getHostName(), this.getPort());
    }

    public Set<InetSocketAddress> getHelperSockets() {
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>();
        String helperHosts = this.configManager.get(RepParams.HELPER_HOSTS);
        if (helperHosts == null) {
            return helpers;
        }
        StringTokenizer tokenizer = new StringTokenizer(helperHosts, ",");
        while (tokenizer.hasMoreTokens()) {
            String hostPortPair = tokenizer.nextToken();
            helpers.add(HostPortPair.getSocket(hostPortPair));
        }
        return helpers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseImpl createGroupDb() throws DatabaseException {
        assert (this.isMaster());
        try {
            this.groupDbLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        try {
            DatabaseImpl newDbImpl;
            block8: {
                if (this.groupDbImpl != null) {
                    throw EnvironmentFailureException.unexpectedState("GroupDb should not exist.");
                }
                newDbImpl = null;
                Txn txn = null;
                try {
                    TransactionConfig txnConfig = new TransactionConfig();
                    txnConfig.setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.NONE));
                    txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
                    txn = new MasterTxn((EnvironmentImpl)this, txnConfig, this.getNameIdPair());
                    DatabaseConfig dbConfig = new DatabaseConfig();
                    dbConfig.setAllowCreate(true);
                    dbConfig.setTransactional(true);
                    dbConfig.setExclusiveCreate(true);
                    DbInternal.setReplicated(dbConfig, true);
                    newDbImpl = this.getDbTree().createInternalDb(txn, "_jeRepGroupDB", dbConfig);
                    txn.commit();
                    txn = null;
                    Object var6_6 = null;
                    if (txn == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (txn == null) throw throwable;
                    txn.abort();
                    throw throwable;
                }
                txn.abort();
            }
            this.groupDbImpl = newDbImpl;
            Object var8_9 = null;
            this.groupDbLock.unlock();
            return this.groupDbImpl;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.groupDbLock.unlock();
            throw throwable;
        }
    }

    @Override
    public long getCleanerBarrierStartFile() {
        if (this.repNode == null) {
            return -1L;
        }
        return this.repNode.getCleanerBarrierFile();
    }

    public DatabaseImpl getGroupDb() throws DatabaseNotFoundException, DatabaseException {
        return this.getGroupDb(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
    }

    public DatabaseImpl getGroupDb(ReplicaConsistencyPolicy policy) throws DatabaseNotFoundException, DatabaseException {
        return this.openGroupDb(policy, false);
    }

    public DatabaseImpl probeGroupDb() throws DatabaseException {
        try {
            return this.openGroupDb(NoConsistencyRequiredPolicy.NO_CONSISTENCY, true);
        }
        catch (DatabaseNotFoundException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl openGroupDb(ReplicaConsistencyPolicy policy, boolean doLockProbe) throws DatabaseNotFoundException, DatabaseException {
        DatabaseImpl databaseImpl;
        block12: {
            Txn txn;
            block10: {
                DatabaseImpl databaseImpl2;
                block11: {
                    try {
                        if (doLockProbe) {
                            if (!this.groupDbLock.tryLock(1L, TimeUnit.MILLISECONDS)) {
                                return null;
                            }
                        } else {
                            this.groupDbLock.lockInterruptibly();
                        }
                    }
                    catch (InterruptedException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                    txn = null;
                    try {
                        if (this.groupDbImpl == null) break block10;
                        databaseImpl2 = this.groupDbImpl;
                        Object var8_7 = null;
                        if (txn == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (txn != null) {
                            txn.abort();
                        }
                        this.groupDbLock.unlock();
                        throw throwable;
                    }
                    txn.abort();
                }
                this.groupDbLock.unlock();
                return databaseImpl2;
            }
            DatabaseImpl newDbImpl = null;
            TransactionConfig txnConfig = new TransactionConfig();
            txnConfig.setConsistencyPolicy(policy);
            txn = new ReadonlyTxn(this, txnConfig);
            newDbImpl = this.getDbTree().getDb(txn, "_jeRepGroupDB", null);
            if (newDbImpl == null) {
                throw new DatabaseNotFoundException("_jeRepGroupDB");
            }
            txn.commit();
            txn = null;
            databaseImpl = this.groupDbImpl = newDbImpl;
            Object var8_8 = null;
            if (txn == null) break block12;
            txn.abort();
        }
        this.groupDbLock.unlock();
        return databaseImpl;
    }

    public boolean isDesignatedPrimary() {
        return this.getConfigManager().getBoolean(RepParams.DESIGNATED_PRIMARY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDbBackup(DbBackup backup) {
        Set<DbBackup> set = this.backups;
        synchronized (set) {
            if (this.backupProhibited) {
                return false;
            }
            assert (this.backups.add(backup));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDbBackup(DbBackup backup) {
        Set<DbBackup> set = this.backups;
        synchronized (set) {
            assert (this.backups.remove(backup));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateBackups(long fileNumber) {
        Set<DbBackup> set = this.backups;
        synchronized (set) {
            for (DbBackup backup : this.backups) {
                backup.invalidate(fileNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackupProhibited(boolean backupProhibited) {
        Set<DbBackup> set = this.backups;
        synchronized (set) {
            this.backupProhibited = backupProhibited;
        }
    }

    @Override
    public LockPreemptedException createLockPreemptedException(Locker locker, Throwable cause) {
        return new LockPreemptedException(locker, cause);
    }

    @Override
    public DatabasePreemptedException createDatabasePreemptedException(String msg, String dbName, Database db) {
        return new DatabasePreemptedException(msg, dbName, db);
    }

    @Override
    public LogOverwriteException createLogOverwriteException(String msg) {
        return new LogOverwriteException(msg);
    }

    public void shutdownGroupSetup(long timeoutMs) {
        int openCount = this.getReferenceCount();
        if (openCount > 1) {
            throw new IllegalStateException("Environment has " + (openCount - 1) + " additional open handles.");
        }
        this.repNode.shutdownGroupOnClose(timeoutMs);
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNameIdPair());
        sb.append("[").append((Object)this.getState()).append("] ");
        if (this.repNode != null) {
            sb.append(this.repNode.dumpState());
        }
        if (this.vlsnIndex != null) {
            sb.append("vlsnRange=");
            sb.append(this.vlsnIndex.getRange()).append("\n");
        }
        if (this.replay != null) {
            sb.append(this.replay.dumpState());
        }
        return sb.toString();
    }

    public void setHardRecoveryInfo(RollbackException e) {
        this.hardRecoveryStat.set(true);
        this.hardRecoveryInfoStat.set(e.getMessage());
    }

    public StatGroup getNodeStats() {
        return this.nodeStats;
    }

    @Override
    public void awaitVLSNConsistency() {
        this.vlsnIndex.awaitConsistency();
    }
}

