/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelector {
    private SortedMap<Long, FileInfo> fileInfoMap = new TreeMap<Long, FileInfo>();
    private Map<Long, LNInfo> pendingLNs = new HashMap<Long, LNInfo>();
    private Set<DatabaseId> pendingDBs = new HashSet<DatabaseId>();
    private boolean anyPendingDuringCheckpoint;
    private Set<Long> lowUtilizationFiles = Collections.emptySet();
    private TestHook fileChosenHook;

    FileSelector() {
    }

    public void setFileChosenHook(TestHook hook) {
        this.fileChosenHook = hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long selectFileForCleaning(UtilizationProfile profile, boolean forceCleaning, boolean calcLowUtilizationFiles, int maxBatchFiles) throws DatabaseException {
        FileSelector fileSelector;
        Long fileNum;
        HashSet<Long> newLowUtilizationFiles = calcLowUtilizationFiles ? new HashSet<Long>() : null;
        while (true) {
            int toBeCleanedSize = this.getNumberOfFiles(FileStatus.TO_BE_CLEANED);
            if (maxBatchFiles > 0 && toBeCleanedSize >= maxBatchFiles || (fileNum = profile.getBestFileForCleaning(this, forceCleaning, newLowUtilizationFiles, toBeCleanedSize > 0)) == null) break;
            assert (TestHookExecute.doHookIfSet(this.fileChosenHook));
            fileSelector = this;
            synchronized (fileSelector) {
                if (!this.isFileCleaningInProgress(fileNum)) {
                    this.setStatus(fileNum, FileStatus.TO_BE_CLEANED);
                }
            }
        }
        if (newLowUtilizationFiles != null) {
            this.lowUtilizationFiles = newLowUtilizationFiles;
        }
        SortedSet<Long> availableFiles = this.getFiles(FileStatus.TO_BE_CLEANED);
        while (availableFiles.size() > 0) {
            fileNum = profile.getCheapestFileToClean(availableFiles);
            if (fileNum == null) {
                return null;
            }
            fileSelector = this;
            synchronized (fileSelector) {
                FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
                if (info != null && info.status == FileStatus.TO_BE_CLEANED) {
                    this.setStatus(fileNum, FileStatus.BEING_CLEANED);
                    return fileNum;
                }
                availableFiles.remove(fileNum);
            }
        }
        return null;
    }

    private synchronized int getNumberOfFiles(FileStatus status) {
        int count = 0;
        for (FileInfo info : this.fileInfoMap.values()) {
            if (info.status != status) continue;
            ++count;
        }
        return count;
    }

    private synchronized SortedSet<Long> getFiles(FileStatus status) {
        TreeSet<Long> set = new TreeSet<Long>();
        for (Map.Entry<Long, FileInfo> entry : this.fileInfoMap.entrySet()) {
            if (entry.getValue().status != status) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    private FileInfo setStatus(Long fileNum, FileStatus newStatus) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        if (info == null) {
            info = new FileInfo();
            this.fileInfoMap.put(fileNum, info);
        }
        info.status = newStatus;
        return info;
    }

    private void setStatus(Collection<Long> files, FileStatus newStatus) {
        for (Long fileNum : files) {
            this.setStatus(fileNum, newStatus);
        }
    }

    private void setStatus(FileStatus oldStatus, FileStatus newStatus) {
        for (FileInfo info : this.fileInfoMap.values()) {
            if (info.status != oldStatus) continue;
            info.status = newStatus;
        }
    }

    private boolean checkStatus(Long fileNum, FileStatus expectStatus) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        assert (info != null) : "Expected " + (Object)((Object)expectStatus) + " but was missing";
        assert (info.status == expectStatus) : "Expected " + (Object)((Object)expectStatus) + " but was " + (Object)((Object)info.status);
        return true;
    }

    private boolean checkStatus(Collection<Long> files, FileStatus expectStatus) {
        for (Long fileNum : files) {
            this.checkStatus(fileNum, expectStatus);
        }
        return true;
    }

    synchronized boolean isFileCleaningInProgress(Long fileNum) {
        return this.fileInfoMap.containsKey(fileNum);
    }

    private boolean isFileCleaningInProgress(Collection<Long> files) {
        for (Long file : files) {
            if (!this.isFileCleaningInProgress(file)) continue;
            return true;
        }
        return false;
    }

    synchronized void removeAllFileReferences(Long fileNum, MemoryBudget budget) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        if (info != null) {
            this.adjustMemoryBudget(budget, info.dbIds, null);
            this.fileInfoMap.remove(fileNum);
        }
    }

    synchronized void putBackFileForCleaning(Long fileNum) {
        assert (this.checkStatus(fileNum, FileStatus.BEING_CLEANED));
        this.setStatus(fileNum, FileStatus.TO_BE_CLEANED);
    }

    public synchronized void injectFileForCleaning(Long fileNum) {
        if (!this.isFileCleaningInProgress(fileNum)) {
            this.setStatus(fileNum, FileStatus.TO_BE_CLEANED);
        }
    }

    synchronized void addCleanedFile(Long fileNum, Set<DatabaseId> databases, VLSN lastVlsn, MemoryBudget budget) {
        assert (this.checkStatus(fileNum, FileStatus.BEING_CLEANED));
        FileInfo info = this.setStatus(fileNum, FileStatus.CLEANED);
        this.adjustMemoryBudget(budget, info.dbIds, databases);
        info.dbIds = databases;
        info.lastVlsn = lastVlsn;
    }

    Set<Long> getLowUtilizationFiles() {
        return this.lowUtilizationFiles;
    }

    synchronized Set<Long> getToBeCleanedFiles() {
        return this.getFiles(FileStatus.TO_BE_CLEANED);
    }

    int getBacklog() {
        return this.getNumberOfFiles(FileStatus.TO_BE_CLEANED);
    }

    synchronized CheckpointStartCleanerState getFilesAtCheckpointStart() {
        this.anyPendingDuringCheckpoint = !this.pendingLNs.isEmpty() || !this.pendingDBs.isEmpty();
        CheckpointStartCleanerState info = new CheckpointStartCleanerState(this.getFiles(FileStatus.CLEANED), this.getFiles(FileStatus.FULLY_PROCESSED));
        return info;
    }

    synchronized void updateFilesAtCheckpointEnd(CheckpointStartCleanerState info) {
        if (!info.isEmpty()) {
            Set<Long> previouslyProcessedFiles;
            Set<Long> previouslyCleanedFiles = info.getCleanedFiles();
            if (previouslyCleanedFiles != null) {
                assert (this.checkStatus(previouslyCleanedFiles, FileStatus.CLEANED));
                this.setStatus(previouslyCleanedFiles, this.anyPendingDuringCheckpoint ? FileStatus.CHECKPOINTED : FileStatus.SAFE_TO_DELETE);
            }
            if ((previouslyProcessedFiles = info.getFullyProcessedFiles()) != null) {
                assert (this.checkStatus(previouslyProcessedFiles, FileStatus.FULLY_PROCESSED));
                this.setStatus(previouslyProcessedFiles, FileStatus.SAFE_TO_DELETE);
            }
            this.updateProcessedFiles();
        }
    }

    synchronized boolean addPendingLN(LN ln, DatabaseId dbId, byte[] key, byte[] dupKey) {
        assert (ln != null);
        boolean added = this.pendingLNs.put(ln.getNodeId(), new LNInfo(ln, dbId, key, dupKey)) != null;
        this.anyPendingDuringCheckpoint = true;
        return added;
    }

    synchronized LNInfo[] getPendingLNs() {
        if (this.pendingLNs.size() > 0) {
            LNInfo[] lns = new LNInfo[this.pendingLNs.size()];
            this.pendingLNs.values().toArray(lns);
            return lns;
        }
        return null;
    }

    synchronized void removePendingLN(long nodeId) {
        this.pendingLNs.remove(nodeId);
        this.updateProcessedFiles();
    }

    private synchronized int getPendingLNQueueSize() {
        return this.pendingLNs.size();
    }

    synchronized boolean addPendingDB(DatabaseId dbId) {
        boolean added = this.pendingDBs.add(dbId);
        this.anyPendingDuringCheckpoint = true;
        return added;
    }

    synchronized DatabaseId[] getPendingDBs() {
        if (this.pendingDBs.size() > 0) {
            DatabaseId[] dbs = new DatabaseId[this.pendingDBs.size()];
            this.pendingDBs.toArray(dbs);
            return dbs;
        }
        return null;
    }

    synchronized void removePendingDB(DatabaseId dbId) {
        this.pendingDBs.remove(dbId);
        this.updateProcessedFiles();
    }

    synchronized SortedSet<Long> copySafeToDeleteFiles() {
        SortedSet<Long> set = this.getFiles(FileStatus.SAFE_TO_DELETE);
        return set.size() > 0 ? set : null;
    }

    synchronized Set<DatabaseId> getCleanedDatabases(Long fileNum) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        return info != null ? new HashSet<DatabaseId>(info.dbIds) : null;
    }

    synchronized VLSN getLastVLSN(Long fileNum) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        return info != null ? info.lastVlsn : null;
    }

    synchronized void removeDeletedFile(Long fileNum, MemoryBudget budget) {
        assert (this.checkStatus(fileNum, FileStatus.SAFE_TO_DELETE));
        FileInfo info = (FileInfo)this.fileInfoMap.remove(fileNum);
        if (info != null) {
            this.adjustMemoryBudget(budget, info.dbIds, null);
        }
    }

    synchronized void close(MemoryBudget budget) {
        for (FileInfo info : this.fileInfoMap.values()) {
            this.adjustMemoryBudget(budget, info.dbIds, null);
        }
    }

    private void updateProcessedFiles() {
        if (this.pendingLNs.isEmpty() && this.pendingDBs.isEmpty()) {
            this.setStatus(FileStatus.CHECKPOINTED, FileStatus.FULLY_PROCESSED);
        }
    }

    private void adjustMemoryBudget(MemoryBudget budget, Set<DatabaseId> oldDatabases, Set<DatabaseId> newDatabases) {
        long adjustMem = 0L;
        if (oldDatabases != null) {
            adjustMem -= this.getCleanedFilesDatabaseEntrySize(oldDatabases);
        }
        if (newDatabases != null) {
            adjustMem += this.getCleanedFilesDatabaseEntrySize(newDatabases);
        }
        budget.updateAdminMemoryUsage(adjustMem);
    }

    private long getCleanedFilesDatabaseEntrySize(Set<DatabaseId> databases) {
        return MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.HASHSET_OVERHEAD + databases.size() * MemoryBudget.HASHSET_ENTRY_OVERHEAD;
    }

    synchronized StatGroup loadStats() {
        StatGroup stats = new StatGroup("FileSelector", "Cleaner's activities when choosing an optimal file to clean.");
        new IntStat(stats, CleanerStatDefinition.CLEANER_BACKLOG, this.getBacklog());
        new IntStat(stats, CleanerStatDefinition.CLEANER_FILE_DELETION_BACKLOG, this.getNumberOfFiles(FileStatus.SAFE_TO_DELETE));
        new IntStat(stats, CleanerStatDefinition.CLEANER_PENDING_LN_QUEUE_SIZE, this.getPendingLNQueueSize());
        return stats;
    }

    public synchronized String toString() {
        return "files = " + this.fileInfoMap + " pendingLNs = " + this.pendingLNs + " pendingDBs = " + this.pendingDBs + " anyPendingDuringCheckpoint = " + this.anyPendingDuringCheckpoint + " lowUtilizationFiles = " + this.lowUtilizationFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckpointStartCleanerState {
        private Set<Long> cleanedFiles;
        private Set<Long> fullyProcessedFiles;

        private CheckpointStartCleanerState(Set<Long> cleanedFiles, Set<Long> fullyProcessedFiles) {
            this.cleanedFiles = cleanedFiles;
            this.fullyProcessedFiles = fullyProcessedFiles;
        }

        public boolean isEmpty() {
            return this.cleanedFiles.size() == 0 && this.fullyProcessedFiles.size() == 0;
        }

        public Set<Long> getCleanedFiles() {
            return this.cleanedFiles;
        }

        public Set<Long> getFullyProcessedFiles() {
            return this.fullyProcessedFiles;
        }
    }

    private static class FileInfo {
        FileStatus status;
        Set<DatabaseId> dbIds;
        VLSN lastVlsn = VLSN.NULL_VLSN;

        private FileInfo() {
        }

        public String toString() {
            return "status = " + (Object)((Object)this.status) + " dbIds = " + this.dbIds + " lastVlsn = " + this.lastVlsn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileStatus {
        TO_BE_CLEANED,
        BEING_CLEANED,
        CLEANED,
        CHECKPOINTED,
        FULLY_PROCESSED,
        SAFE_TO_DELETE;

    }
}

