/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.apps.gui.jutil.BrowsePanel;
import net.handle.apps.gui.jutil.HDLToolConfig;
import net.handle.apps.gui.jutil.PasswordPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Util;

public class PublicKeyJPanel
extends JPanel {
    private final JTextField userIdHandleField;
    private final JTextField userIdIndexField;
    private PrivateKey privateKey = null;
    private final BrowsePanel browser;

    public PublicKeyJPanel() {
        super(new GridBagLayout());
        String s = HDLToolConfig.table.getStr((Object)"PubHandle", "");
        this.userIdHandleField = new JTextField(s, 25);
        this.userIdHandleField.setScrollOffset(0);
        this.userIdHandleField.setToolTipText("Input handle name");
        s = HDLToolConfig.table.getStr((Object)"PubIndex", "300");
        this.userIdIndexField = new JTextField(s, 5);
        this.userIdIndexField.setToolTipText("Input handle value index");
        s = HDLToolConfig.table.getStr((Object)"PrivKey", "");
        this.browser = new BrowsePanel("Private Key File: ", new File(s), "", null, false);
        int x = 0;
        int y = 0;
        this.add((Component)new JLabel(" ID Handle: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.userIdHandleField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        this.add((Component)new JLabel(" ID Index: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.userIdIndexField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)0.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(1, 1, 1, 30), (int)17, (boolean)false, (boolean)false));
        this.add((Component)this.browser, AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)1.0, (int)3, (int)1, (boolean)true, (boolean)true));
    }

    public String getPrivKeyPath() {
        return this.browser.getPath();
    }

    public PrivateKey getPrivKey() {
        File[] files = new File[1];
        InputStream in = null;
        if (!this.browser.getReadFile(files)) {
            return null;
        }
        try {
            File pkFile = files[0];
            if (!pkFile.isFile()) {
                return null;
            }
            byte[] rawKey = new byte[(int)pkFile.length()];
            in = new FileInputStream(pkFile);
            int r = 0;
            for (int n = 0; n < rawKey.length && (r = in.read(rawKey, n, rawKey.length - n)) > 0; n += r) {
            }
            in.close();
            byte[] secretKey = null;
            if (Util.requiresSecretKey((byte[])rawKey)) {
                String[] passPhrase = new String[1];
                if (!PasswordPanel.show(passPhrase, false)) {
                    return null;
                }
                secretKey = Util.encodeString((String)passPhrase[0]);
            }
            byte[] keyBytes = Util.decrypt((byte[])rawKey, secretKey);
            try {
                this.privateKey = Util.getPrivateKeyFromBytes((byte[])keyBytes, (int)0);
            }
            catch (Exception e) {
                if (secretKey != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e1) {
                        return null;
                    }
                    JOptionPane.showMessageDialog(null, "There was an error decrypting your private key.\nAre you sure that you entered the correct passphrase?\nPlease try again.", "Warning: ", 2);
                    return null;
                }
                throw e;
            }
            return this.privateKey;
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e1) {
                    return null;
                }
                JOptionPane.showMessageDialog(null, "Error loading private key: " + e, "Warning: ", 2);
            }
            return null;
        }
    }

    public int getUserIdIndex() {
        return Integer.parseInt(this.userIdIndexField.getText());
    }

    public String getUserIdHandle() {
        return this.userIdHandleField.getText().trim();
    }

    public void setUserIdIndex(int index) {
        this.userIdIndexField.setText(Integer.toString(index));
    }

    public void setUserIdHandle(String handle) {
        this.userIdHandleField.setText(handle);
    }
}

