/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ListHandleJPanel
extends JPanel
implements ActionListener,
ResponseMessageCallback {
    private final JTextField naField;
    private final JRadioButton outFileRadio;
    private final JTextField outFileField;
    private final JRadioButton outWindowRadio;
    private final JButton browseFileButton;
    private final JButton submitButton;
    private final JButton changeAuthButton;
    private final JTextArea consoleArea;
    private Writer hdlOut = null;
    private final HandleTool tool;

    public ListHandleJPanel(HandleTool tool) {
        this.tool = tool;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.consoleArea = new JTextArea(10, 30);
        this.consoleArea.setEditable(false);
        this.naField = new JTextField("", 12);
        this.outFileRadio = new JRadioButton("File:", false);
        this.outWindowRadio = new JRadioButton("Window:", true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.outFileRadio);
        bg.add(this.outWindowRadio);
        this.outFileField = new JTextField("handles.txt", 12);
        this.browseFileButton = new JButton("Browse...");
        this.submitButton = new JButton("Submit");
        this.changeAuthButton = new JButton("Authentication");
        int x = 0;
        int y = 0;
        this.add((Component)new JLabel("Prefix: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.naField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        JPanel tmpPanel = new JPanel(gridbag);
        tmpPanel.add((Component)this.changeAuthButton, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)0.0, (int)1, (int)1, (boolean)false, (boolean)false));
        tmpPanel.add((Component)this.submitButton, AwtUtil.getConstraints((int)1, (int)0, (double)1.0, (double)0.0, (int)1, (int)1, (boolean)false, (boolean)false));
        this.add((Component)tmpPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints((int)x, (int)y++, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)new JLabel("Output To: "), AwtUtil.getConstraints((int)x, (int)y++, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        tmpPanel = new JPanel(gridbag);
        tmpPanel.add((Component)this.outFileRadio, AwtUtil.getConstraints((int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        tmpPanel.add((Component)this.outFileField, AwtUtil.getConstraints((int)1, (int)0, (double)1.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        tmpPanel.add((Component)this.browseFileButton, AwtUtil.getConstraints((int)2, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)tmpPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints((int)x, (int)y++, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        tmpPanel = new JPanel(gridbag);
        tmpPanel.add((Component)this.outWindowRadio, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        tmpPanel.add((Component)new JScrollPane(this.consoleArea), AwtUtil.getConstraints((int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)tmpPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.submitButton.addActionListener(this);
        this.browseFileButton.addActionListener(this);
        this.changeAuthButton.addActionListener(this);
        this.outFileRadio.addActionListener(this);
        this.outWindowRadio.addActionListener(this);
        this.outputSelected();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.submitButton) {
            this.listHandles();
        } else if (src == this.browseFileButton) {
            this.selectFile();
        } else if (src == this.changeAuthButton) {
            this.tool.changeAuthentication();
        } else if (src == this.outFileRadio || src == this.outWindowRadio) {
            this.outputSelected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listHandles() {
        AuthenticationInfo authInfo;
        String prefix = this.naField.getText().trim();
        if (prefix.length() <= 0) {
            JOptionPane.showMessageDialog(this, "Missing prefix", "Error Message: ", 0);
            return;
        }
        byte[] naHandle = Util.encodeString((String)prefix);
        if (!Util.hasSlash((byte[])naHandle)) {
            naHandle = Util.convertSlashlessHandleToZeroNaHandle((byte[])naHandle);
        }
        if ((authInfo = this.tool.getAuthentication()) == null) {
            return;
        }
        ListHandlesRequest req = new ListHandlesRequest(naHandle, authInfo);
        this.consoleArea.setText("");
        this.consoleArea.repaint();
        try {
            this.hdlOut = this.outFileRadio.isSelected() ? new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outFileField.getText())), "UTF-8") : new ConsoleWriter();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error setting up output: " + e, "Error Message", 0);
            return;
        }
        try {
            ResolutionRequest dudReq = new ResolutionRequest(Util.encodeString((String)(prefix + "/test")), null, null, null);
            System.err.println("finding local sites for " + dudReq);
            SiteInfo[] sites = this.tool.resolver.findLocalSites((AbstractRequest)dudReq);
            SiteInfo site = sites[Math.abs(new Random().nextInt()) % sites.length];
            System.err.println("contacting site: " + site);
            this.tool.resolver.setTcpTimeout(300000);
            if (site.majorProtocolVersion == 5 && site.minorProtocolVersion == 0 || site.majorProtocolVersion < 2 || site.majorProtocolVersion == 2 && site.minorProtocolVersion < 11) {
                req.majorProtocolVersion = site.majorProtocolVersion;
                req.minorProtocolVersion = site.minorProtocolVersion;
            } else {
                req.majorProtocolVersion = (byte)2;
                req.minorProtocolVersion = (byte)11;
            }
            for (int i = 0; i < site.servers.length; ++i) {
                ServerInfo server = site.servers[i];
                System.err.println(" contacting server: " + server);
                try {
                    AbstractResponse response = this.tool.resolver.sendRequestToServer((AbstractRequest)req, site, server, (ResponseMessageCallback)this);
                    if (response.responseCode == 1) continue;
                    System.err.println("got error: " + response);
                    JOptionPane.showMessageDialog(this, "Error: " + response, "Error Message", 0);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Error: " + e, "Error Message", 0);
        }
        finally {
            if (this.hdlOut != null) {
                try {
                    this.hdlOut.close();
                }
                catch (Exception exception) {}
                this.hdlOut = null;
            }
        }
        System.err.println("done listing handles...");
    }

    public void handleResponse(AbstractResponse response) {
        if (response instanceof ListHandlesResponse) {
            try {
                ListHandlesResponse lhResp = (ListHandlesResponse)response;
                byte[][] handles = lhResp.handles;
                for (int i = 0; i < handles.length; ++i) {
                    this.hdlOut.write(Util.decodeString((byte[])handles[i]));
                    this.hdlOut.write("\n");
                    this.hdlOut.flush();
                }
            }
            catch (Exception e) {
                System.err.println("Error: " + e);
                e.printStackTrace(System.err);
            }
        } else if (response.responseCode != 402) {
            JOptionPane.showMessageDialog(this, "Error: " + response, "Error Message", 0);
        }
    }

    private void selectFile() {
        File selectedFile;
        String path = this.outFileField.getText();
        JFileChooser jfc = path.trim().length() > 0 ? new JFileChooser(path) : new JFileChooser();
        int result = jfc.showSaveDialog(this);
        if (result == 0 && (selectedFile = jfc.getSelectedFile()) != null) {
            this.outFileField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void outputSelected() {
        boolean toFile = this.outFileRadio.isSelected();
        this.consoleArea.setEnabled(!toFile);
        this.browseFileButton.setEnabled(toFile);
        this.outFileField.setEnabled(toFile);
    }

    private class ConsoleWriter
    extends Writer {
        private ConsoleWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            ListHandleJPanel.this.consoleArea.append(new String(cbuf, off, len));
            ListHandleJPanel.this.consoleArea.repaint();
        }

        @Override
        public void write(String str) {
            ListHandleJPanel.this.consoleArea.append(str);
            ListHandleJPanel.this.consoleArea.repaint();
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

