/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.URL;
import java.security.PublicKey;
import java.security.Signature;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import net.handle.apps.gui.hadmin.BackupServerWindow;
import net.handle.apps.gui.hadmin.BatchHandleJPanel;
import net.handle.apps.gui.hadmin.Console;
import net.handle.apps.gui.hadmin.CreateHandleJPanel;
import net.handle.apps.gui.hadmin.HomeNAWindow;
import net.handle.apps.gui.hadmin.IPRedirectPanel;
import net.handle.apps.gui.hadmin.ListHandleJPanel;
import net.handle.apps.gui.hadmin.ModifyHandleJPanel;
import net.handle.apps.gui.hadmin.QueryHandleJPanel;
import net.handle.apps.gui.hadmin.RemoveHandleJPanel;
import net.handle.apps.gui.hadmin.SessionSetupJPanel;
import net.handle.apps.gui.hadmin.UnhomeNAWindow;
import net.handle.apps.gui.hadmin.WorkWindow;
import net.handle.apps.gui.jutil.HelpPanel;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jwidget.AuthenJPanel;
import net.handle.apps.gui.jwidget.GenerateKeyJPanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.TaskIndicator;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.Common;
import net.handle.hdllib.DumpHandlesCallback;
import net.handle.hdllib.DumpHandlesResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.VerifyAuthRequest;
import net.handle.hdllib.VerifyAuthResponse;

public class HandleTool
extends JFrame
implements ActionListener {
    private AuthenticationInfo authInfo = null;
    HandleResolver resolver = null;
    boolean errFlag = false;
    Console console;
    JCheckBoxMenuItem showConsoleMenuItem;
    JLabel authStatus;
    private final String[][] bname = new String[][]{{"     Query Handle     ", "query", "Search24.gif"}, {"     Create Handle     ", "create", "New24.gif"}, {"     Modify Handle     ", "modify", "Edit24.gif"}, {"     Remove Handle     ", "remove", "Delete24.gif"}, {"       Run Batch     ", "batch", "History24.gif"}, {"      Server Admin     ", "server", "Server24.gif"}, {"        Setup     ", "config", "Preferences24.gif"}, {"         Help    ", "help", "Help24.gif"}, {"         Exit     ", "exit", "Stop24.gif"}};
    JPopupMenu configMenu = new JPopupMenu("Configuration");
    JPopupMenu serverMenu = new JPopupMenu("Server Tasks");

    public HandleTool() {
        this(new HandleResolver());
    }

    public HandleTool(HandleResolver resolver) {
        super("Handle Admin Tool");
        JMenuItem item;
        this.resolver = resolver;
        this.resolver.traceMessages = true;
        this.resolver.setPreferredProtocols(new int[]{1, 2});
        URL res = this.getClass().getResource("icons/hs_logo.gif");
        Image img = new ImageIcon(res).getImage();
        this.setIconImage(img);
        this.console = new Console();
        this.console.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                HandleTool.this.showConsoleMenuItem.setState(false);
            }
        });
        GridBagLayout grid = new GridBagLayout();
        JPanel content = new JPanel(grid);
        Insets inset = new Insets(3, 3, 3, 3);
        JPanel p1 = new JPanel(grid);
        MyButton[] buttons = new MyButton[this.bname.length];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.bname.length; ++i) {
            res = this.getClass().getResource("icons/" + this.bname[i][2]);
            buttons[i] = new MyButton(this.bname[i][0], null, this.bname[i][1], new ImageIcon(res));
            buttons[i].setHorizontalAlignment(2);
            buttons[i].setHorizontalTextPosition(4);
            buttons[i].addActionListener(this);
            p1.add((Component)buttons[i], AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)2, (int)1, (Insets)inset, (boolean)true, (boolean)false));
            if (this.bname[i][1].equals("server")) {
                this.serverMenu.setInvoker(buttons[i]);
                continue;
            }
            if (!this.bname[i][1].equals("config")) continue;
            this.configMenu.setInvoker(buttons[i]);
        }
        String[][] serverItems = new String[][]{{"Home Prefix", "home"}, {"Unhome Prefix", "unhome"}, {"Backup Server", "backup"}, {"List Handles", "list"}};
        for (int i = 0; i < serverItems.length; ++i) {
            item = new JMenuItem(serverItems[i][0]);
            item.setActionCommand(serverItems[i][1]);
            item.addActionListener(this);
            this.serverMenu.add(item);
        }
        String[][] configItems = new String[][]{{"Authentication", "auth"}, {"Session Settings", "session"}, {"Generate Key Pairs", "keys"}, {"IP/Firewall Redirection", "ipredirect"}};
        for (int i = 0; i < configItems.length; ++i) {
            item = new JMenuItem(configItems[i][0]);
            item.setActionCommand(configItems[i][1]);
            this.configMenu.add(item);
            item.addActionListener(this);
        }
        this.showConsoleMenuItem = new JCheckBoxMenuItem("Show Console");
        this.showConsoleMenuItem.setActionCommand("console");
        this.configMenu.add(this.showConsoleMenuItem);
        this.showConsoleMenuItem.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.authStatus = new JLabel("No authentication set.");
        this.authStatus.setFont(new Font("Dialog", 0, 10));
        p2.add(this.authStatus);
        content.add((Component)p1, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)inset, (boolean)true, (boolean)true));
        content.add((Component)p2, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)2, (int)1, (Insets)inset, (boolean)true, (boolean)true));
        this.setContentPane(content);
        this.setSize(100, 200);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                System.exit(0);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String choice = ae.getActionCommand();
        if (choice.equals("exit")) {
            System.exit(0);
        } else if (choice.equals("help")) {
            HelpPanel.show(this, "/net/handle/apps/gui/help/en_en", "intro.html");
        } else if (choice.equals("create")) {
            this.createHandle();
        } else if (choice.equals("modify")) {
            this.modifyHandle();
        } else if (choice.equals("remove")) {
            this.removeHandle();
        } else if (choice.equals("query")) {
            this.queryHandle();
        } else if (choice.equals("batch")) {
            this.batchHandle();
        } else if (choice.equals("config")) {
            this.configMenu.show(this.configMenu.getInvoker(), 100, 0);
        } else if (choice.equals("server")) {
            this.serverMenu.show(this.serverMenu.getInvoker(), 100, 0);
        } else if (choice.equals("home")) {
            this.homeNA();
        } else if (choice.equals("unhome")) {
            this.unhomeNA();
        } else if (choice.equals("keys")) {
            this.genKeys();
        } else if (choice.equals("console")) {
            this.console.setVisible(!this.console.isVisible());
        } else if (choice.equals("list")) {
            this.listHandles();
        } else if (choice.equals("backup")) {
            this.backupServer();
        } else if (choice.equals("session")) {
            this.sessionSetup();
        } else if (choice.equals("auth")) {
            this.changeAuthentication();
        } else if (choice.equals("ipredirect")) {
            this.setupIPRedirection();
        } else {
            System.err.println("uncaught action in HandleTool.java: " + choice);
        }
    }

    private void createHandle() {
        CreateHandleJPanel createp = new CreateHandleJPanel(this);
        createp.reset();
        WorkWindow.show(this, "Create Handle:", createp, "/net/handle/apps/gui/help/en_en", "createhandle.html");
    }

    private void modifyHandle() {
        ModifyHandleJPanel modifyp = new ModifyHandleJPanel(this);
        WorkWindow.show(this, "Modify Handle:", modifyp, "/net/handle/apps/gui/help/en_en", "modifyhandle.html");
    }

    private void removeHandle() {
        RemoveHandleJPanel removep = new RemoveHandleJPanel(this);
        WorkWindow.show(this, "Remove Handle:", removep, "/net/handle/apps/gui/help/en_en", "removehandle.html");
    }

    private void queryHandle() {
        QueryHandleJPanel queryp = new QueryHandleJPanel(this);
        WorkWindow.show(this, "Query Handle:", queryp, "/net/handle/apps/gui/help/en_en", "queryhandle.html");
    }

    private void batchHandle() {
        BatchHandleJPanel batchp = new BatchHandleJPanel(this);
        WorkWindow.show(this, "Batch Submit Handles:", batchp, "/net/handle/apps/gui/help/en_en", "batchhandle.html");
    }

    private void homeNA() {
        AuthenticationInfo auth = this.getAuthentication();
        if (auth == null) {
            return;
        }
        HomeNAWindow homenaWin = new HomeNAWindow(this);
        homenaWin.setVisible(true);
    }

    private void unhomeNA() {
        AuthenticationInfo auth = this.getAuthentication();
        if (auth == null) {
            return;
        }
        UnhomeNAWindow unhomeWin = new UnhomeNAWindow(this);
        unhomeWin.setVisible(true);
    }

    private void backupServer() {
        AuthenticationInfo auth = this.getAuthentication();
        if (auth == null) {
            return;
        }
        BackupServerWindow backupWin = new BackupServerWindow(this);
        backupWin.setVisible(true);
    }

    public SessionSetupInfo getSessionSetupInfo() {
        ClientSessionTracker t = this.resolver.getSessionTracker();
        if (t == null) {
            return null;
        }
        return t.getSessionSetupInfo();
    }

    private void sessionSetup() {
        SessionSetupJPanel sessionWin = new SessionSetupJPanel(this, this.getSessionSetupInfo());
        sessionWin.setLocation(this.getLocation());
        sessionWin.setVisible(true);
    }

    private void genKeys() {
        GenerateKeyJPanel keygenWin = new GenerateKeyJPanel();
        WorkWindow.show(this, "Generate Key Pair:", keygenWin, "/net/handle/apps/gui/help/en_en", "gen_keypairs.html");
    }

    private void listHandles() {
        ListHandleJPanel listWin = new ListHandleJPanel(this);
        WorkWindow.show(this, "List Handles:", listWin, "/net/handle/apps/gui/help/en_en", "listhandle.html");
    }

    public AuthenticationInfo getCurrentAuthentication() {
        return this.authInfo;
    }

    public AuthenticationInfo getAuthentication() {
        if (this.authInfo != null) {
            return this.authInfo;
        }
        AuthenJPanel authp = new AuthenJPanel();
        while (2 != JOptionPane.showConfirmDialog(this, authp, "Authentication", 2, -1)) {
            try {
                AuthenticationInfo tempAuthInfo = authp.getAuthInfo();
                if (tempAuthInfo == null) {
                    return null;
                }
                CheckAuthentication checkAuth = new CheckAuthentication(tempAuthInfo);
                TaskIndicator ti = new TaskIndicator((Component)this);
                ti.invokeTask((Runnable)checkAuth, "Checking Authentication ...");
                if (checkAuth.getFlag()) {
                    int newIndex;
                    if (tempAuthInfo instanceof PublicKeyAuthenticationInfo && tempAuthInfo.getUserIdIndex() == 0 && (newIndex = checkAuth.getIndex()) > 0) {
                        tempAuthInfo = new PublicKeyAuthenticationInfo(tempAuthInfo.getUserIdHandle(), newIndex, ((PublicKeyAuthenticationInfo)tempAuthInfo).getPrivateKey());
                    }
                    this.authInfo = tempAuthInfo;
                    StringBuffer s = new StringBuffer();
                    s.append(new String(this.authInfo.getAuthType()));
                    s.append(" ");
                    s.append(new String(this.authInfo.getUserIdHandle()));
                    s.append(":");
                    s.append(this.authInfo.getUserIdIndex());
                    this.authStatus.setText(s.toString());
                    return this.authInfo;
                }
                String errorMsg = checkAuth.getErrorMessage();
                String msg = errorMsg == null ? "Authentication failed" : "Authentication failed: " + errorMsg;
                JOptionPane.showMessageDialog(this, msg, "Error", 0);
                continue;
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(this, "Error: " + t.getMessage(), "Error", 0);
                continue;
            }
            break;
        }
        return null;
    }

    public void setupIPRedirection() {
        IPRedirectPanel redirectPanel = new IPRedirectPanel(this.resolver.getConfiguration());
        int result = JOptionPane.showConfirmDialog(this, redirectPanel, "Authentication", 2, -1);
        if (result == 0) {
            redirectPanel.saveRecords();
        }
    }

    public AuthenticationInfo changeAuthentication() {
        AuthenticationInfo oldInfo = this.authInfo;
        this.authInfo = null;
        this.authInfo = this.getAuthentication();
        if (this.authInfo == null) {
            this.authInfo = oldInfo;
        }
        return this.authInfo;
    }

    public AbstractResponse processRequest(Component parent, AbstractRequest req, String label) throws Exception {
        ProcessRequest proc = new ProcessRequest(req);
        TaskIndicator ti = new TaskIndicator(parent);
        ti.invokeTask((Runnable)proc, label);
        return proc.getResponse();
    }

    public AbstractResponse processRequest(Component parent, AbstractRequest req, ServerInfo server, String label) throws Exception {
        ProcessRequest proc = new ProcessRequest(req, server);
        TaskIndicator ti = new TaskIndicator(parent);
        ti.invokeTask((Runnable)proc, label);
        return proc.getResponse();
    }

    public AbstractResponse processRequest(Component parent, AbstractRequest req, InetAddress serverIP, int port, int protocol, String label) throws Exception {
        ProcessRequest proc = new ProcessRequest(req, serverIP, port, protocol);
        TaskIndicator ti = new TaskIndicator(parent);
        ti.invokeTask((Runnable)proc, label);
        return proc.getResponse();
    }

    public void processStreamedResponse(Component parent, DumpHandlesResponse resp, DumpHandlesCallback callback, PublicKey publicKey, String label) throws Exception {
        ProcessStream proc = new ProcessStream(resp, callback, publicKey);
        TaskIndicator ti = new TaskIndicator(parent);
        ti.invokeTask((Runnable)proc, label);
        proc.end();
    }

    public static void main(String[] args) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ChallengeResponse.initializeRandom();
            }
        });
        t.start();
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") != -1 || osName.indexOf("Solaris") != -1 || osName.indexOf("SunOS") != -1 || osName.indexOf("Mac") != -1) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HandleTool ht = new HandleTool();
        ht.setLocation(200, 200);
        ht.setVisible(true);
    }

    class ProcessStream
    implements Runnable {
        DumpHandlesCallback callback;
        PublicKey publicKey;
        DumpHandlesResponse streamedResponse;
        Exception exception;
        boolean endFlag = false;

        ProcessStream(DumpHandlesResponse streamedResponse, DumpHandlesCallback callback, PublicKey publicKey) {
            this.callback = callback;
            this.publicKey = publicKey;
            this.streamedResponse = streamedResponse;
        }

        @Override
        public void run() {
            try {
                this.streamedResponse.processStreamedPart(this.callback, this.publicKey);
                this.endFlag = true;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.exception = e;
            }
        }

        public void end() {
            if (this.endFlag) {
                return;
            }
            try {
                DumpHandlesResponse tmpResp = this.streamedResponse;
                if (tmpResp.stream != null) {
                    tmpResp.stream.close();
                    tmpResp.stream = null;
                }
                this.callback.processThisServerReplicationInfo(0L, 0L);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.exception = e;
            }
        }

        public void getException() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    class ProcessRequest
    implements Runnable {
        private AbstractResponse response = null;
        private AbstractRequest request = null;
        private Exception exception = null;
        private InetAddress serverIP = null;
        private ServerInfo server = null;
        private int port = -1;
        private int protocol = -1;
        private int sendtype = 1;

        ProcessRequest(AbstractRequest req) {
            this.request = req;
            this.sendtype = 0;
        }

        ProcessRequest(AbstractRequest req, ServerInfo server) {
            this.request = req;
            this.server = server;
            this.sendtype = 1;
        }

        ProcessRequest(AbstractRequest req, InetAddress serverIP, int port, int protocol) {
            this.request = req;
            this.serverIP = serverIP;
            this.port = port;
            this.protocol = protocol;
            this.sendtype = 2;
        }

        @Override
        public void run() {
            try {
                block1 : switch (this.sendtype) {
                    case 0: {
                        this.response = HandleTool.this.resolver.processRequest(this.request);
                        break;
                    }
                    case 1: {
                        this.response = HandleTool.this.resolver.sendRequestToServer(this.request, this.server);
                        break;
                    }
                    case 2: {
                        switch (this.protocol) {
                            case 1: {
                                this.response = HandleTool.this.resolver.sendHdlTcpRequest(this.request, this.serverIP, this.port);
                                break block1;
                            }
                            case 0: {
                                this.response = HandleTool.this.resolver.sendHdlUdpRequest(this.request, this.serverIP, this.port);
                                break block1;
                            }
                            case 2: {
                                this.response = HandleTool.this.resolver.sendHttpRequest(this.request, this.serverIP, this.port);
                                break block1;
                            }
                        }
                        new Exception("Invalid server protocol type").printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                this.exception = e;
                this.response = null;
            }
        }

        public AbstractResponse getResponse() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.response;
        }
    }

    class CheckAuthentication
    implements Runnable {
        boolean succFlag = false;
        String errorMessage = null;
        AuthenticationInfo auth;
        int index;

        CheckAuthentication(AuthenticationInfo auth) {
            this.auth = auth;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void run() {
            try {
                this.succFlag = this.checkAuth();
            }
            catch (Exception e) {
                this.errorMessage = String.valueOf(e);
                e.printStackTrace(System.err);
                this.succFlag = false;
            }
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean getFlag() {
            return this.succFlag;
        }

        boolean checkAuth() throws Exception {
            ResolutionRequest dummyReq = new ResolutionRequest(Common.BLANK_HANDLE, null, null, null);
            dummyReq.majorProtocolVersion = (byte)2;
            dummyReq.minorProtocolVersion = 1;
            ChallengeResponse challResp = new ChallengeResponse((AbstractRequest)dummyReq, true);
            challResp.majorProtocolVersion = (byte)2;
            challResp.minorProtocolVersion = 1;
            byte[] authBytes = this.auth.authenticate(challResp, (AbstractRequest)dummyReq);
            if (Util.equals((byte[])this.auth.getAuthType(), (byte[])Common.SECRET_KEY_TYPE)) {
                VerifyAuthRequest vaReq = new VerifyAuthRequest(this.auth.getUserIdHandle(), challResp.nonce, challResp.requestDigest, challResp.rdHashType, authBytes, this.auth.getUserIdIndex(), null);
                vaReq.certify = true;
                AbstractResponse response = HandleTool.this.resolver.processRequest((AbstractRequest)vaReq);
                if (!(response instanceof VerifyAuthResponse)) {
                    throw new Exception("Unable to verify authentication \n" + response);
                }
                return ((VerifyAuthResponse)response).isValid;
            }
            if (Util.equals((byte[])this.auth.getAuthType(), (byte[])Common.PUBLIC_KEY_TYPE)) {
                int[] nArray;
                byte[] byArray = this.auth.getUserIdHandle();
                byte[][] byArray2 = this.auth.getUserIdIndex() > 0 ? null : Common.PUBLIC_KEY_TYPES;
                if (this.auth.getUserIdIndex() > 0) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = this.auth.getUserIdIndex();
                } else {
                    nArray = null;
                }
                ResolutionRequest req = new ResolutionRequest(byArray, byArray2, nArray, null);
                req.certify = true;
                AbstractResponse response = HandleTool.this.resolver.processRequest((AbstractRequest)req);
                if (!(response instanceof ResolutionResponse)) {
                    throw new Exception("Unable to verify authentication \n" + response);
                }
                HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
                if (values == null || values.length < 1) {
                    throw new Exception("The admin index specified does not exist\n");
                }
                int offset = 0;
                byte[] hashAlgId = Encoder.readByteArray((byte[])authBytes, (int)offset);
                byte[] sigBytes = Encoder.readByteArray((byte[])authBytes, (int)(offset += 4 + hashAlgId.length));
                offset += 4 + sigBytes.length;
                for (int i = 0; i < values.length; ++i) {
                    if (this.auth.getUserIdIndex() > 0 && this.auth.getUserIdIndex() != values[i].getIndex()) continue;
                    PublicKey pubKey = Util.getPublicKeyFromBytes((byte[])values[i].getData(), (int)0);
                    Signature sig = Signature.getInstance(Util.getSigIdFromHashAlgId((byte[])hashAlgId, (String)pubKey.getAlgorithm()));
                    sig.initVerify(pubKey);
                    sig.update(challResp.nonce);
                    sig.update(challResp.requestDigest);
                    if (!sig.verify(sigBytes)) continue;
                    this.index = values[i].getIndex();
                    return true;
                }
                return false;
            }
            System.err.println("Unknown auth type: \n" + Util.decodeString((byte[])this.auth.getAuthType()));
            throw new Exception("Unknown authentication type : \n" + Util.decodeString((byte[])this.auth.getAuthType()));
        }
    }
}

