/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Console
extends JFrame {
    private final JTextArea console = new JTextArea(40, 80);

    public Console() {
        super("Console");
        this.console.setEditable(false);
        this.setSize(new Dimension(800, 400));
        this.getContentPane().add(new JScrollPane(this.console));
        ConsoleStream errStream = new ConsoleStream(System.err);
        PrintStream errPrintStream = new PrintStream(errStream, true);
        ConsoleStream outStream = new ConsoleStream(System.out);
        PrintStream outPrintStream = new PrintStream(outStream, true);
        System.setErr(errPrintStream);
        System.setOut(outPrintStream);
        this.setVisible(false);
    }

    class ConsoleStream
    extends OutputStream {
        PrintStream stream;
        int MAX_CHARS = 32768;

        public ConsoleStream(PrintStream stream) {
            this.stream = stream;
        }

        private void checkSize() {
            String txt = Console.this.console.getText();
            if (txt.length() > this.MAX_CHARS) {
                int i = (txt = txt.substring(this.MAX_CHARS / 2)).indexOf("\n");
                if (i > 0) {
                    txt = txt.substring(i);
                }
                Console.this.console.setText(txt);
            }
        }

        @Override
        public void write(byte[] buf) throws IOException {
            Console.this.console.append(new String(buf));
            this.stream.write(buf);
            this.checkSize();
        }

        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            Console.this.console.append(new String(buf, offset, length));
            this.stream.write(buf, offset, length);
            this.checkSize();
        }

        @Override
        public void write(int i) throws IOException {
            Console.this.console.append(String.valueOf((char)i));
            this.stream.write(i);
            this.checkSize();
        }
    }
}

