/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.handle.apps.gui.jutil.MyRadioButton;
import net.handle.apps.gui.jwidget.PubkeyDataJPanel;
import net.handle.apps.gui.jwidget.SecretKeyDataJPanel;
import net.handle.apps.gui.jwidget.VListDataJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleValue;

public class AdministMasterJPanel
extends JPanel
implements ActionListener {
    private final ButtonGroup bgroup;
    private final MyRadioButton seckeyButton;
    private final MyRadioButton pubkeyButton;
    private final MyRadioButton admgrpButton;
    private int preSelection = -1;
    private int index = -1;
    private HandleValue handlevalue = null;

    public AdministMasterJPanel(int index) {
        super(new GridBagLayout());
        this.index = index;
        JPanel p = new JPanel(new FlowLayout());
        this.seckeyButton = new MyRadioButton("Secret Key", "Admin Secret Key Reference");
        this.pubkeyButton = new MyRadioButton("Public Key", "Admin Public Key Reference");
        this.admgrpButton = new MyRadioButton("Admin Group", "Admin Group Reference");
        this.seckeyButton.addActionListener(this);
        this.pubkeyButton.addActionListener(this);
        this.admgrpButton.addActionListener(this);
        this.bgroup = new ButtonGroup();
        this.bgroup.add(this.seckeyButton);
        this.bgroup.add(this.pubkeyButton);
        this.bgroup.add(this.admgrpButton);
        p.add(this.seckeyButton);
        p.add(this.pubkeyButton);
        p.add(this.admgrpButton);
        int x = 0;
        int y = 0;
        this.add((Component)p, AwtUtil.getConstraints((int)x, (int)y, (double)1.0, (double)1.0, (int)3, (int)1, (boolean)false, (boolean)false));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Secret Key")) {
            this.onSecretKey();
        } else if (ae.getActionCommand().equals("Public Key")) {
            this.onPublicKey();
        } else if (ae.getActionCommand().equals("Admin Group")) {
            this.onAdminGroup();
        }
    }

    public HandleValue getAdmReferValue() {
        return this.handlevalue;
    }

    private void onSecretKey() {
        SecretKeyDataJPanel p = new SecretKeyDataJPanel(Common.STD_TYPE_HSSECKEY, true, true);
        p.setIndex(this.index);
        if (2 == JOptionPane.showConfirmDialog(null, p, "Input secret key: ", 2, -1)) {
            this.setPreSelection();
            return;
        }
        this.preSelection = 0;
        this.handlevalue = p.getHandleValue();
        this.handlevalue.setIndex(p.getIndex());
    }

    private void onPublicKey() {
        PubkeyDataJPanel p = new PubkeyDataJPanel(true, true);
        p.setIndex(this.index);
        if (2 == JOptionPane.showConfirmDialog(null, p, "Input public key: ", 2, -1)) {
            this.setPreSelection();
            return;
        }
        this.preSelection = 1;
        this.handlevalue = p.getHandleValue();
        this.handlevalue.setIndex(p.getIndex());
    }

    private void onAdminGroup() {
        VListDataJPanel p = new VListDataJPanel(true, true);
        p.setIndex(this.index);
        if (2 == JOptionPane.showConfirmDialog(null, p, "Input administrator group: ", 2, -1)) {
            this.setPreSelection();
            return;
        }
        this.preSelection = 2;
        this.handlevalue = p.getHandleValue();
        this.handlevalue.setIndex(p.getIndex());
    }

    private void setPreSelection() {
        switch (this.preSelection) {
            case 0: {
                this.seckeyButton.setSelected(true);
                break;
            }
            case 1: {
                this.pubkeyButton.setSelected(true);
                break;
            }
            case 2: {
                this.admgrpButton.setSelected(true);
                break;
            }
            case -1: {
                this.seckeyButton.setSelected(false);
                this.pubkeyButton.setSelected(false);
                this.admgrpButton.setSelected(false);
            }
        }
    }
}

